/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;

public class HgRebaseCommand {
    @NotNull
    private final Project project;
    @NotNull
    private final HgRepository repo;

    public HgRebaseCommand(@NotNull Project project, @NotNull HgRepository repo) {
        this.project = project;
        this.repo = repo;
    }

    @Nullable
    public HgCommandResult startRebase() {
        return this.performRebase(ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    @Nullable
    public HgCommandResult continueRebase() {
        return this.performRebase("--continue");
    }

    @Nullable
    public HgCommandResult abortRebase() {
        return this.performRebase("--abort");
    }

    @Nullable
    private HgCommandResult performRebase(String ... args) {
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.project, (String)"Rebase");){
            ArrayList list = ContainerUtil.newArrayList((Object[])args);
            list.add("--config");
            list.add("extensions.rebase=");
            HgCommandResult result = new HgCommandExecutor(this.project).executeInCurrentThread(this.repo.getRoot(), "rebase", list);
            this.repo.update();
            HgCommandResult hgCommandResult = result;
            return hgCommandResult;
        }
    }
}

