/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerSettings;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleCoroutineDebugProjectResolver;", "Lorg/jetbrains/plugins/gradle/service/project/AbstractProjectResolverExtension;", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "enhanceTaskProcessing", "", "taskNames", "", "", "jvmParametersSetup", "initScriptConsumer", "Lcom/intellij/util/Consumer;", "setupCoroutineAgentForJvmForkedTestTasks", "kotlin.gradle.gradle-idea"})
public final class KotlinGradleCoroutineDebugProjectResolver
extends AbstractProjectResolverExtension {
    @NotNull
    private final Logger log;

    @NotNull
    public final Logger getLog() {
        return this.log;
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmParametersSetup, @NotNull Consumer<String> initScriptConsumer) {
        Intrinsics.checkNotNullParameter(taskNames, (String)"taskNames");
        Intrinsics.checkNotNullParameter(initScriptConsumer, (String)"initScriptConsumer");
        try {
            boolean disableCoroutineAgent = KotlinDebuggerSettings.Companion.getInstance().getDebugDisableCoroutineAgent();
            if (!disableCoroutineAgent) {
                this.setupCoroutineAgentForJvmForkedTestTasks(initScriptConsumer);
            }
        }
        catch (Exception e) {
            this.log.error("Gradle: not possible to attach a coroutine debugger agent.", (Throwable)e);
        }
    }

    private final void setupCoroutineAgentForJvmForkedTestTasks(Consumer<String> initScriptConsumer) {
        String script = "gradle.taskGraph.beforeTask { Task task ->\n    if (task instanceof Test || task instanceof JavaExec) {\n        def kotlinxCoroutinesCoreJar = task.classpath.find { it.name.startsWith(\"kotlinx-coroutines-core\") }\n        if (kotlinxCoroutinesCoreJar) {\n            def results = (kotlinxCoroutinesCoreJar.getName() =~ /kotlinx-coroutines-core(\\-jvm)?-(\\d[\\w\\.\\-]+)\\.jar$/).findAll()\n            if (results) {\n                def version = results.first()[2]\n                def referenceVersion = org.gradle.util.VersionNumber.parse('1.3.7-255')\n                if (org.gradle.util.VersionNumber.parse(version) > referenceVersion) {\n                    task.jvmArgs (\"-javaagent:${kotlinxCoroutinesCoreJar?.absolutePath}\", \"-ea\")\n                }\n            }\n        }\n    }\n}";
        initScriptConsumer.consume((Object)script);
    }

    public KotlinGradleCoroutineDebugProjectResolver() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(this::class.java)");
        this.log = logger;
    }
}

