/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NativeCrashHandling
implements BaseComponent {
    public void initComponent() {
        List crashes = StudioCrashDetection.reapCrashDescriptions();
        for (StudioCrashDetails crash : crashes) {
            if (!NativeCrashHandling.isCrashCausedByLayoutlib(crash)) continue;
            PluginManagerCore.disablePlugin((String)"com.android.layoutlib.native");
            PluginManagerCore.enablePlugin((String)"com.android.layoutlib.standard");
            ApplicationManager.getApplication().restart();
        }
    }

    private static boolean isCrashCausedByLayoutlib(@NotNull StudioCrashDetails crash) {
        return crash.isJvmCrash() && (crash.getErrorThread().contains("Layoutlib Render Thread") || crash.getErrorFrame().contains("libandroid_runtime"));
    }
}

