/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class ExprBinary
extends Expr {
    public static final int OR = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int AND = 5;
    public static final int ADD = 6;
    public static final int LESS = 7;
    public static final int LESSEQU = 8;
    public static final int GREATER = 9;
    public static final int GREATEREQU = 10;
    public static final int EQU = 11;
    public static final int UNEQU = 23;
    private int opCode;
    private Expr left;
    private Expr right;

    public ExprBinary(int opCode, Expr left, Expr right, Context context2) {
        super(context2);
        this.opCode = opCode;
        this.left = left;
        this.right = right;
    }

    @Override
    public int interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable) {
        switch (this.opCode) {
            case 6: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) + this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 1: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) - this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 2: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) * this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 3: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) / this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 4: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) % this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 5: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) & this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 0: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) | this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable);
            }
            case 7: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) < this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
            case 8: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) <= this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
            case 9: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) > this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
            case 10: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) >= this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
            case 11: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) == this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
            case 23: {
                return this.left.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) != this.right.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) ? 1 : 0;
            }
        }
        throw new RuntimeException(Messages.getString(ExprBinary.class.getName() + "-0"));
    }
}

