/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class CMakeFilePathPartsRenameHolder {
    private String myNewContent;
    private String myOldStart;
    private String myOldEnd;

    public CMakeFilePathPartsRenameHolder invoke(@NotNull PsiElement argument, @NotNull TextRange range, String newContent) {
        String oldFullContent = argument.getText();
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        this.myNewContent = StringUtil.trimEnd((String)newContent, (String)"/");
        if (this.myNewContent.isEmpty()) {
            if (endOffset + 1 < oldFullContent.length() && oldFullContent.charAt(endOffset) == '/') {
                ++endOffset;
            } else if (startOffset - 1 > 0 && oldFullContent.charAt(startOffset) == '/') {
                --startOffset;
            } else {
                this.myNewContent = ".";
            }
        }
        this.myOldStart = oldFullContent.substring(0, startOffset);
        this.myOldEnd = oldFullContent.substring(endOffset);
        return this;
    }

    public String getNewContent() {
        return this.myNewContent;
    }

    public String getOldStart() {
        return this.myOldStart;
    }

    public String getOldEnd() {
        return this.myOldEnd;
    }
}

