/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import com.intellij.util.PairProcessor;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.settings.CMakeCodeStyleSettings;
import com.jetbrains.cmake.settings.Case;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakePreFormatProcessor
implements PreFormatProcessor {
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiFile containingFile;
        PsiElement psiElement = element.getPsi();
        PsiFile psiFile = containingFile = psiElement == null || !psiElement.isValid() ? null : psiElement.getContainingFile();
        if (!(containingFile instanceof CMakeFile)) {
            return range;
        }
        return new MyFormatter(psiElement).process(range);
    }

    private static class MyFormatter {
        @NotNull
        protected final Project myProject;
        @NotNull
        protected final PsiElement myElement;
        @NotNull
        protected final PsiDocumentManager myDocumentManager;
        @Nullable
        protected final Document myDocument;
        protected final CMakeCodeStyleSettings myCMakeCodeStyleSettings;

        MyFormatter(@NotNull PsiElement element) {
            this.myProject = element.getProject();
            this.myElement = element;
            this.myCMakeCodeStyleSettings = (CMakeCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), CMakeCodeStyleSettings.class);
            this.myDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
            this.myDocument = this.myDocumentManager.getDocument(element.getContainingFile());
        }

        @NotNull
        private TextRange process(final @NotNull TextRange range) {
            if (this.myDocument == null || this.myCMakeCodeStyleSettings == null || this.myCMakeCodeStyleSettings.hasDoNotChangeFileSettings()) {
                return range;
            }
            final ArrayList functionsToChangeCase = new ArrayList();
            this.myElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(@NotNull PsiElement element) {
                    IElementType type;
                    ASTNode currentNode = element.getNode();
                    TextRange nodeRange = currentNode.getTextRange();
                    if (range.intersects(nodeRange) && this.intersectWithEditable(element) && ((type = currentNode.getElementType()) == CMakeElementTypes.ID || MyFormatter.isFunctionOrMacroName(currentNode, type) || MyFormatter.isKeyword(type))) {
                        functionsToChangeCase.add(nodeRange);
                    }
                    super.visitElement(element);
                }
            });
            CharSequence charSequence = this.myDocument.getCharsSequence();
            DocumentUtil.executeInBulk((Document)this.myDocument, (boolean)true, () -> {
                PairProcessor processor2 = (range1, s) -> {
                    TextRange shifted = TextRange.create((int)range1.getStartOffset(), (int)range1.getEndOffset());
                    if (this.myDocument.getText(shifted).equals(s)) {
                        return true;
                    }
                    if (this.myDocument.getRangeGuard(shifted.getStartOffset(), shifted.getEndOffset()) != null) {
                        return true;
                    }
                    this.myDocument.replaceString(shifted.getStartOffset(), shifted.getEndOffset(), (CharSequence)s);
                    return true;
                };
                MyFormatter.processNames(functionsToChangeCase, charSequence, (PairProcessor<TextRange, String>)processor2, Case.resolveByValue(this.myCMakeCodeStyleSettings.FORCE_COMMANDS_CASE));
            });
            if (this.myDocumentManager.isUncommited(this.myDocument)) {
                this.myDocumentManager.commitDocument(this.myDocument);
            }
            return range;
        }

        private static boolean isFunctionOrMacroName(@NotNull ASTNode currentNode, @NotNull IElementType currentNodeType) {
            if (currentNodeType != CMakeElementTypes.C_MAKE_ARGUMENT) {
                return false;
            }
            ASTNode possibleCommandArguments = currentNode.getTreeParent();
            if (possibleCommandArguments == null || possibleCommandArguments.getElementType() != CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS || possibleCommandArguments.getFirstChildNode().getTreeNext() != currentNode) {
                return false;
            }
            ASTNode possibleFunctionOrMacroNode = possibleCommandArguments.getTreeParent();
            return possibleFunctionOrMacroNode != null && CMakeElementTypes.CMAKE_FUNCTION_AND_MACRO_NAME_HOLDERS.contains(possibleFunctionOrMacroNode.getElementType());
        }

        private static boolean isKeyword(@NotNull IElementType currentNodeType) {
            return CMakeElementTypes.KEYWORDS.contains(currentNodeType);
        }

        private boolean intersectWithEditable(@NotNull PsiElement element) {
            if (!(this.myDocument instanceof DocumentWindow)) {
                return true;
            }
            return !InjectedLanguageManager.getInstance((Project)this.myProject).intersectWithAllEditableFragments(element.getContainingFile(), element.getNode().getTextRange()).isEmpty();
        }

        private static void processNames(@NotNull List<TextRange> functionRanges, @NotNull CharSequence charSequence, @NotNull PairProcessor<TextRange, String> processor2, @Nullable Case mode) {
            if (mode == null) {
                return;
            }
            if (mode == Case.DO_NOT_CHANGE) {
                return;
            }
            for (TextRange range : functionRanges) {
                String text = charSequence.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
                String newText = mode.apply(text);
                processor2.process((Object)range, (Object)newText);
            }
        }
    }
}

