/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.project.CidrChangeProjectContentRootAction;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceProvider;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrWorkspace {
    @Nullable
    protected static BalloonNotifier ourBalloonNotifier;
    @NotNull
    protected final Project myProject;
    @Nullable
    private volatile Path myProjectDir;
    @Nullable
    protected volatile File myContentRoot;
    private volatile boolean myBaseStateInitialized = false;
    private volatile boolean isInitialized = false;
    private volatile boolean myReportFilesOutsideRoots;
    private volatile boolean myIgnoreFilesOutsideOfProjectRoot;
    protected final Disposable myBusConnectionDisposable = Disposer.newDisposable();

    @NotNull
    public static List<CidrWorkspace> getInitializedWorkspaces(@NotNull Project project2) {
        return ContainerUtil.immutableList(CidrWorkspaceManager.getInstance(project2).getInitializedWorkspaces());
    }

    @NotNull
    public static List<CidrWorkspace> getWorkspaces(@NotNull Project project2) {
        return CidrWorkspaceProvider.EP_NAME.getExtensionList().stream().map(provider2 -> provider2.getWorkspace(project2)).filter(workspace -> workspace != null).collect(Collectors.toList());
    }

    protected CidrWorkspace(@NotNull Project project2) {
        this.myProject = project2;
    }

    protected boolean shouldLoadWorkspaceForProject() {
        return !this.myProject.isDefault() && !ProjectManagerImpl.isLight((Project)this.myProject);
    }

    public boolean isLinked() {
        return this.myProjectDir != null;
    }

    public final boolean wasLinkedBefore() {
        return this.isLinked() || this.myContentRoot != null;
    }

    protected final void linkWithProject(@Nullable Path projectDir) {
        this.myProjectDir = projectDir;
    }

    protected final void unlink() {
        this.myProjectDir = null;
    }

    protected final void linkWithProject(@Nullable Path projectDir, boolean preserveContentRoot) {
        if (preserveContentRoot) {
            this.preserveContentRootIfNecessary(projectDir);
        }
        this.linkWithProject(projectDir);
    }

    private void preserveContentRootIfNecessary(@Nullable Path newProjectDir) {
        Path projectDir = this.myProjectDir;
        if (projectDir == null && newProjectDir == null || projectDir != null && this.myContentRoot != null) {
            return;
        }
        this.setContentRoot(newProjectDir, this.getProjectPath().toFile());
    }

    protected final void setContentRoot(@Nullable File newContentRoot) {
        this.setContentRoot(this.myProjectDir, newContentRoot);
    }

    protected final void setContentRoot(@Nullable Path projectDir, @Nullable File newContentRoot) {
        this.myContentRoot = newContentRoot != null && (projectDir == null || !FileUtil.pathsEqual((String)projectDir.toString(), (String)newContentRoot.getPath())) ? newContentRoot : null;
    }

    public final boolean isInitialized() {
        return this.isInitialized;
    }

    @NotNull
    protected abstract OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File var1);

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Path getProjectSubDir(@NotNull Path subdir) {
        if (subdir.isAbsolute()) {
            return subdir;
        }
        return this.getProjectPath().resolve(subdir).toAbsolutePath();
    }

    @Deprecated
    @NotNull
    public File getProjectDir() {
        return this.getProjectPath().toFile();
    }

    @Nullable
    protected final Path getProjectPathOrNull() {
        return this.myProjectDir;
    }

    @NotNull
    private Path getFallbackProjectPath() {
        String basePath = this.myProject.getBasePath();
        if (basePath == null) {
            throw new NullPointerException("Project base path is null. default = " + this.myProject.isDefault());
        }
        return Paths.get(basePath, new String[0]);
    }

    @NotNull
    public Path getProjectPath() {
        Path projectDir = this.getProjectPathOrNull();
        return (projectDir != null ? projectDir : this.getFallbackProjectPath()).toAbsolutePath();
    }

    protected boolean initializeAndStart() {
        return this.markInitialized();
    }

    public boolean load(boolean projectOpening) {
        return this.shouldLoadWorkspaceForProject() && this.isLinked() && this.initializeAndStart();
    }

    public boolean unload(boolean projectClosing) {
        return this.markUninitialized();
    }

    private synchronized boolean markInitialized() {
        this.isInitialized = true;
        return CidrWorkspaceManager.getInstance(this.myProject).markInitialized(this);
    }

    private synchronized boolean markUninitialized() {
        this.isInitialized = false;
        return CidrWorkspaceManager.getInstance(this.myProject).markUninitialized(this);
    }

    public final List<String> collectExcludeUrls() {
        return ContainerUtil.map(this.collectExcludeRoots(this.myContentRoot, true), file2 -> VfsUtilCore.pathToUrl((String)file2.getPath()));
    }

    @NotNull
    public List<File> collectExcludeRoots(@Nullable File contentRoot, boolean includePotentialNotYetExistingExcludes) {
        return Collections.emptyList();
    }

    @Nullable
    protected File beforeUpdateContentRoots(@Nullable File contentRoot) {
        if (contentRoot != null && this.isLinked()) {
            this.setContentRoot(contentRoot);
            return this.myContentRoot;
        }
        return contentRoot;
    }

    protected void afterUpdateContentRoots(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        boolean reportOutsideFiles = this.outsideFilesExist(rootsInfo);
        if (!reportOutsideFiles) {
            this.myIgnoreFilesOutsideOfProjectRoot = false;
        }
        this.myReportFilesOutsideRoots = reportOutsideFiles;
    }

    protected boolean shouldEnableRootConfiguration() {
        return this.isLinked();
    }

    public final void updateContentRoots() {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this);
    }

    protected final void updateContentRoots(boolean forceRootChangesEvents) {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this, forceRootChangesEvents);
    }

    protected final void updateContentRoots(@Nullable File contentRoot) {
        OCRootsSynchronizer.getInstance(this.myProject).updateRoots(this, contentRoot);
    }

    protected boolean outsideFilesExist(@NotNull OCRootsSynchronizer.RootsInfo rootsInfo) {
        return !OCRootsSynchronizer.isUnder(rootsInfo.contentRoots, rootsInfo.sourceFiles);
    }

    protected void reportFilesOutsideContentRoot(@NotNull String message, @Nullable String toolWindowId) {
        if (this.myReportFilesOutsideRoots && !this.myIgnoreFilesOutsideOfProjectRoot) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            final HyperlinkAdapter listener = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    if ("change".equals(e.getDescription())) {
                        CidrChangeProjectContentRootAction.perform(CidrWorkspace.this.myProject, CidrWorkspace.this);
                    } else if ("ignore".equals(e.getDescription())) {
                        CidrWorkspace.this.myIgnoreFilesOutsideOfProjectRoot = true;
                    }
                }
            };
            if (ourBalloonNotifier != null) {
                ourBalloonNotifier.notify(MessageType.WARNING, message, (HyperlinkListener)listener);
            } else if (toolWindowId != null) {
                ToolWindowManager.getInstance((Project)this.myProject).notifyByBalloon(toolWindowId, MessageType.WARNING, message, null, (HyperlinkListener)listener);
            } else {
                NotificationListener notificationListener = new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        listener.hyperlinkUpdate(event);
                        notification.expire();
                    }
                };
                String id = "Workspace";
                NotificationGroup notificationGroup = NotificationGroup.findRegisteredGroup((String)"Workspace");
                if (notificationGroup == null) {
                    notificationGroup = NotificationGroup.balloonGroup((String)"Workspace");
                }
                Notification notification = notificationGroup.createNotification(null, null, message, NotificationType.WARNING, notificationListener);
                notification.notify(this.myProject);
            }
        }
    }

    public void changeContentRoot(@Nullable VirtualFile contentRoot) {
        this.myIgnoreFilesOutsideOfProjectRoot = false;
        this.updateContentRoots(contentRoot == null ? null : VfsUtilCore.virtualToIoFile((VirtualFile)contentRoot));
    }

    public static OCRootsSynchronizer.RootsInfo createRootsInfo(@NotNull List<OCResolveConfiguration> resolveConfigurations, @NotNull List<File> roots2, @NotNull List<File> additionalSourceFiles, @NotNull List<File> generatedSourceFiles) {
        OCRootsSynchronizer.RootsInfo info = new OCRootsSynchronizer.RootsInfo();
        info.contentRoots.addAll(roots2);
        for (OCResolveConfiguration it : resolveConfigurations) {
            for (String sourceUrl : it.getSourceUrls()) {
                info.sourceFiles.add(new File(VfsUtilCore.urlToPath((String)sourceUrl)));
            }
            it.getAllCompilerSettings().forEach(settings -> info.headersSearchRoots.addAll(settings.getHeadersSearchRoots().getAllRoots()));
        }
        info.sourceFiles.addAll(additionalSourceFiles);
        info.generatedSourceFiles.addAll(generatedSourceFiles);
        return info;
    }

    @Nullable
    public VirtualFile getEffectiveContentRoot() {
        File root = this.myContentRoot;
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    @Nullable
    public Module getModule() {
        return OCRootsSynchronizer.getInstance(this.myProject).getModuleIfExists();
    }

    @Nullable
    public File getContentRoot() {
        return this.myContentRoot;
    }

    @NotNull
    public State getBaseState() {
        Path projectDir = this.myProjectDir;
        return new State(projectDir == null ? null : projectDir.toFile(), this.myContentRoot, this.myIgnoreFilesOutsideOfProjectRoot);
    }

    public void noStateLoaded() {
        this.myBaseStateInitialized = true;
    }

    public void loadBaseState(@NotNull State state) {
        Path projectDir = state.myProjectDir != null ? state.myProjectDir.toPath() : null;
        this.myContentRoot = state.myContentRoot;
        this.myIgnoreFilesOutsideOfProjectRoot = state.myIgnoreFilesOutsideOfProjectRoot;
        this.linkWithProject(projectDir, this.myBaseStateInitialized);
        this.myBaseStateInitialized = true;
    }

    public static void setBalloonNotifierInTests(@Nullable BalloonNotifier notifier) {
        ourBalloonNotifier = notifier;
    }

    public static interface BalloonNotifier {
        public void notify(@NotNull MessageType var1, @NotNull String var2, @NotNull HyperlinkListener var3);
    }

    public static class State {
        @Nullable
        public File myProjectDir = null;
        @Nullable
        public File myContentRoot = null;
        public boolean myIgnoreFilesOutsideOfProjectRoot = false;

        public State() {
        }

        public State(@Nullable File projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            this.myProjectDir = projectDir;
            this.myContentRoot = contentRoot;
            this.myIgnoreFilesOutsideOfProjectRoot = ignoreFilesOutsideOfProjectRoot;
        }

        @NotNull
        public Element createElement() {
            return State.createStateElement(this);
        }

        @NotNull
        public static Element createStateElement(@Nullable Path projectDir, @Nullable File contentRoot, boolean ignoreFilesOutsideOfProjectRoot) {
            return State.createStateElement(new State(projectDir != null ? projectDir.toFile() : null, contentRoot, ignoreFilesOutsideOfProjectRoot));
        }

        @NotNull
        public static Element createStateElement(@NotNull State state) {
            Element element = new Element("state");
            if (state.myIgnoreFilesOutsideOfProjectRoot) {
                element.setAttribute("IGNORE_OUTSIDE_FILES", "true");
            }
            if (state.myProjectDir != null) {
                element.setAttribute("PROJECT_DIR", FileUtil.toSystemIndependentName((String)state.myProjectDir.getPath()));
            }
            if (state.myContentRoot != null) {
                Element contentRootElement = new Element("contentRoot");
                contentRootElement.setAttribute("DIR", FileUtil.toSystemIndependentName((String)state.myContentRoot.getPath()));
                element.addContent(contentRootElement);
            }
            return element;
        }

        @NotNull
        public static State loadStateElement(@NotNull Element element) {
            State state = new State();
            state.loadElement(element);
            return state;
        }

        public void loadElement(@NotNull Element element) {
            String projectDirString = element.getAttributeValue("PROJECT_DIR");
            this.myProjectDir = projectDirString == null ? null : new File(projectDirString);
            Element contentRootElement = element.getChild("contentRoot");
            String contentRootDirString = contentRootElement == null ? null : contentRootElement.getAttributeValue("DIR");
            this.myContentRoot = contentRootDirString == null ? null : new File(contentRootDirString);
            this.myIgnoreFilesOutsideOfProjectRoot = Boolean.parseBoolean(element.getAttributeValue("IGNORE_OUTSIDE_FILES"));
        }
    }
}

