/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IncludedHeadersRoot
extends HeadersRoot {
    private final boolean myRecursive;
    private final HeadersSearchPath.Kind myKind;

    @NotNull
    public static IncludedHeadersRoot create(@NotNull Project project2, @NotNull VirtualFile includedDir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
        return new Transient(project2, includedDir, recursive, kind);
    }

    @NotNull
    public static IncludedHeadersRoot create(@NotNull Project project2, @NotNull VirtualFilePointer includedDir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
        return new Pointer(project2, includedDir, recursive, kind);
    }

    private IncludedHeadersRoot(@NotNull Project project2, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
        super(project2);
        this.myRecursive = recursive;
        this.myKind = kind;
    }

    @NotNull
    public String getName() {
        return "Included Headers";
    }

    @NotNull
    public abstract String getUrl();

    public boolean isRecursive() {
        return this.myRecursive;
    }

    @Override
    @NotNull
    public HeadersSearchPath.Kind getKind() {
        return this.myKind;
    }

    public abstract boolean isSynthetic();

    public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        return IncludedHeadersRoot.processUnder(processor2, this.getVirtualFile(), this.myRecursive, this.myProject);
    }

    public String toString() {
        return this.getName() + " @ " + this.getUrl() + ": " + this.myKind.toString() + (this.myRecursive ? " [recursive]" : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IncludedHeadersRoot root = (IncludedHeadersRoot)((Object)o);
        return this.myRecursive == root.myRecursive && this.myKind == root.myKind;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myRecursive, this.myKind});
    }

    private static class Pointer
    extends IncludedHeadersRoot {
        @NotNull
        private final VirtualFilePointer myPointer;

        private Pointer(@NotNull Project project2, @NotNull VirtualFilePointer dir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
            super(project2, recursive, kind);
            this.myPointer = dir;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myPointer.getFile();
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myPointer.getUrl();
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public boolean isValid() {
            return this.myPointer.isValid();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Pointer pointer = (Pointer)((Object)o);
            return this.myPointer.equals(pointer.myPointer);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myPointer.hashCode();
        }
    }

    private static class Transient
    extends IncludedHeadersRoot {
        @NotNull
        private final VirtualFile myFile;

        private Transient(@NotNull Project project2, @NotNull VirtualFile dir, boolean recursive, @NotNull HeadersSearchPath.Kind kind) {
            super(project2, recursive, kind);
            this.myFile = dir;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public String getUrl() {
            return this.myFile.getUrl();
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }

        @Override
        public boolean isValid() {
            return this.myFile.isValid();
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            Transient that = (Transient)((Object)o);
            return this.myFile.equals(that.myFile);
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.myFile.hashCode();
        }
    }
}

