/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializerMember;
import com.jetbrains.cidr.lang.psi.OCDesignatedInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveExtraInitializersIntentionAction;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompoundInitializerChecker {
    @NotNull
    private final OCCompoundInitializer myCompoundInitializer;
    @Nullable
    private final OCType myTypeToInitialize;
    private final boolean myAllowImplicitConversions;
    @NotNull
    private final OCResolveContext myContext;
    @NotNull
    private final List<OCCompoundInitializerMember> myInitializers;
    @NotNull
    private final List<OCExpression> myInitializerExprs;
    private Boolean myIsAggregate = null;
    private boolean mySingleInitializerTypeCalculated = false;
    @Nullable
    private OCType mySingleInitializerType = null;

    public static OCTypeCheckResult checkCompoundInitializer(OCCompoundInitializer compInitializer, @Nullable OCType type, boolean allowImplicitConversions, @NotNull OCResolveContext context2) {
        return new OCCompoundInitializerChecker(compInitializer, type, allowImplicitConversions, context2).doCheck();
    }

    public OCCompoundInitializerChecker(@NotNull OCCompoundInitializer initializer, @Nullable OCType typeToInitialize, boolean allowImplicitConversions, @NotNull OCResolveContext context2) {
        this.myCompoundInitializer = initializer;
        this.myTypeToInitialize = typeToInitialize;
        this.myAllowImplicitConversions = allowImplicitConversions;
        this.myContext = context2;
        this.myInitializers = this.myCompoundInitializer.getInitializers();
        this.myInitializerExprs = this.myCompoundInitializer.getInitializerExpressions();
    }

    private boolean isEmpty() {
        return this.myInitializers.isEmpty();
    }

    private boolean isAggregate() {
        if (this.myIsAggregate == null) {
            this.myIsAggregate = this.myTypeToInitialize != null && TypeProperties.isAggregateType(this.myTypeToInitialize);
        }
        return this.myIsAggregate;
    }

    private boolean isCppStructOrUnion() {
        if (this.myTypeToInitialize instanceof OCStructType && this.myContext.isCpp()) {
            OCSymbolKind kind = ((OCStructType)this.myTypeToInitialize).getKind();
            return kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.UNION;
        }
        return false;
    }

    private OCType getReferencedType() {
        return OCTypeUtils.getCppReferencedType(this.myTypeToInitialize);
    }

    @Nullable
    private OCType getSingleInitializerType() {
        if (!this.mySingleInitializerTypeCalculated) {
            if (this.myInitializers.size() == 1 && this.myInitializers.get(0) instanceof OCTypeOwner) {
                this.mySingleInitializerType = OCTypeUtils.getCppReferencedType(((OCExpression)this.myInitializers.get(0)).getResolvedType(this.myContext));
            }
            this.mySingleInitializerTypeCalculated = true;
        }
        return this.mySingleInitializerType;
    }

    private OCTypeCheckResult doCheck() {
        OCExpression innerMember;
        if (this.myTypeToInitialize instanceof OCEllipsisType) {
            return OCTypeCheckResult.createOK();
        }
        if (this.myTypeToInitialize instanceof OCMagicType || this.myTypeToInitialize != null && this.myTypeToInitialize.isUnknown()) {
            return OCTypeCheckResult.createOK();
        }
        if (this.getSingleInitializerType() != null && this.isAggregate() && OCTypeUtils.isSameOrDerivedFrom(this.getSingleInitializerType(), this.myTypeToInitialize, this.myContext)) {
            return OCTypeCheckResult.createOK();
        }
        if (this.myTypeToInitialize != null && this.myTypeToInitialize.isCString() && this.getSingleInitializerType() instanceof OCArrayType && (innerMember = OCParenthesesUtils.diveIntoParentheses(this.myInitializerExprs.get(0))) instanceof OCLiteralExpression) {
            return this.myTypeToInitialize.checkCompatible(this.getSingleInitializerType(), innerMember, innerMember, true, this.myContext);
        }
        if (this.myTypeToInitialize instanceof OCArrayType || this.isAggregate()) {
            if (!(this.myTypeToInitialize instanceof OCStructType) || !((OCStructType)this.myTypeToInitialize).isPredeclaration()) {
                return this.checkAggregate();
            }
            return OCTypeCheckResult.createOK();
        }
        if (this.isEmpty() && this.isCppStructOrUnion() && ((OCStructType)this.myTypeToInitialize).getSymbol().hasDefaultConstructor(this.myContext)) {
            OCTypeCheckResult okResult = new OCTypeCheckResult(OCTypeCheckState.OK);
            okResult.setImplicitConstructor(((OCStructType)this.myTypeToInitialize).getSymbol().getDefaultConstructor(this.myContext));
            return okResult;
        }
        OCType stdInitListParameter = OCCodeInsightUtil.getStdInitializerListTemplateParameter(this.myTypeToInitialize, this.myContext);
        if (stdInitListParameter != null) {
            if (TypeProperties.hasSameUnqualifiedType(this.myTypeToInitialize, this.getSingleInitializerType(), this.myContext)) {
                return OCTypeCheckResult.createOK();
            }
            OCArgumentsList<OCExpression> argumentsList = OCArgumentsList.getArgumentList(this.myInitializerExprs);
            ArrayList<OCTypeCheckResult> results = new ArrayList<OCTypeCheckResult>();
            for (int i2 = 0; i2 < argumentsList.getTypes().size(); ++i2) {
                OCExpression argument = argumentsList.getExprs().get(i2);
                OCType argumentType = argumentsList.getTypes().get(i2);
                results.add(stdInitListParameter.checkCompatible(argumentType, argument, argument, true, this.myContext));
            }
            return OCCompoundInitializerChecker.combine(results);
        }
        if (this.isCppStructOrUnion()) {
            if (this.myInitializers.stream().anyMatch(e -> e instanceof OCDesignatedInitializer)) {
                return OCTypeCheckResult.createError();
            }
            return this.checkConstructors();
        }
        if (this.getSingleInitializerType() != null && (!(this.myTypeToInitialize instanceof OCCppReferenceType) || OCTypeUtils.isSameOrDerivedFrom(this.getSingleInitializerType(), this.getReferencedType(), this.myContext))) {
            OCCompoundInitializerMember initializer;
            OCTypeCheckResult result2 = OCTypeCheckResult.createOK();
            if (this.myTypeToInitialize != null && (initializer = this.myInitializers.get(0)) instanceof OCExpression) {
                result2 = this.myTypeToInitialize.checkCompatible(((OCExpression)initializer).getResolvedType(), (OCExpression)initializer, initializer, true, this.myContext);
            }
            return result2;
        }
        if (this.myTypeToInitialize instanceof OCCppReferenceType) {
            boolean isNonConstRvalueRef;
            OCCppReferenceType ref = (OCCppReferenceType)this.myTypeToInitialize;
            boolean bl = isNonConstRvalueRef = !ref.isReferenceToConst() && !ref.isRvalueRef();
            if (isNonConstRvalueRef) {
                if (ref.isCppStructType(this.myContext)) {
                    return OCTypeCheckResult.createError();
                }
                return OCTypeCheckResult.createError();
            }
            return this.getReferencedType().checkCompatible(this.myCompoundInitializer.getResolvedType(this.myContext), this.myCompoundInitializer, this.myCompoundInitializer, true, this.myContext);
        }
        if (this.isEmpty()) {
            if (!this.myCompoundInitializer.getContainingOCFile().isCpp()) {
                return OCTypeCheckResult.createError();
            }
            return OCTypeCheckResult.createOK();
        }
        if (this.myInitializers.size() > 1 && this.myTypeToInitialize != null && this.myTypeToInitialize.isScalar()) {
            return OCTypeCheckResult.createError();
        }
        return OCTypeCheckResult.createError();
    }

    @NotNull
    private OCTypeCheckResult checkConstructors() {
        assert (this.myTypeToInitialize instanceof OCStructType);
        OCArgumentsList<OCCompoundInitializer> arguments = new OCArgumentsList<OCCompoundInitializer>(Collections.singletonList(this.myCompoundInitializer.getResolvedType()), Collections.singletonList(this.myCompoundInitializer));
        FindConstructorResult result2 = ((OCStructType)this.myTypeToInitialize).findConstructor(arguments, this.myContext, this.myCompoundInitializer, this.myAllowImplicitConversions, null, true);
        OCFunctionSymbol constructor = result2.getSymbol();
        if (constructor instanceof OCFunctionGroupSymbol) {
            OCFunctionGroupSymbol group = (OCFunctionGroupSymbol)constructor;
            switch (group.getCause()) {
                case Ambiguous: {
                    return OCTypeCheckResult.createError();
                }
                case NoViable: {
                    return OCTypeCheckResult.createError();
                }
            }
            return OCTypeCheckResult.createOK();
        }
        if (constructor != null) {
            OCTypeCheckResult okResult = OCTypeCheckResult.createOK();
            okResult.setImplicitConstructor(constructor);
            return okResult;
        }
        return OCTypeCheckResult.createError();
    }

    private OCTypeCheckResult checkAggregate() {
        int curInitializerIndex = 0;
        boolean excessInitializers = false;
        HashMap<PsiElement, Pair<OCType, OCSymbol>> childTypes = new HashMap<PsiElement, Pair<OCType, OCSymbol>>();
        childTypes.put(this.myCompoundInitializer, new Pair((Object)this.myTypeToInitialize, null));
        this.myCompoundInitializer.inferChildTypes(childTypes, new HashSet<OCSymbol>());
        ArrayList<OCTypeCheckResult> results = new ArrayList<OCTypeCheckResult>();
        for (OCCompoundInitializerMember member : this.myInitializers) {
            if (member instanceof OCExpression) {
                Pair<OCType, OCSymbol> pair = childTypes.get(member);
                OCType childType = (OCType)Pair.getFirst(pair);
                if (childType != null) {
                    childType = childType.resolve(this.myContext);
                    OCType rType = ((OCExpression)member).getResolvedType();
                    if (member instanceof OCCompoundInitializer) {
                        results.add(OCCompoundInitializerChecker.checkCompoundInitializer((OCCompoundInitializer)member, childType, true, this.myContext));
                    } else {
                        results.add(childType.checkCompatible(rType, (OCExpression)member, member, true, this.myContext));
                    }
                } else if (!excessInitializers) {
                    excessInitializers = true;
                    OCRemoveExtraInitializersIntentionAction fix = new OCRemoveExtraInitializersIntentionAction(this.myInitializers, curInitializerIndex);
                    OCTypeCheckResult result2 = new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP){

                        @Override
                        public boolean canBeCasted(OCType lType, OCType rType, @NotNull OCResolveContext context2) {
                            return false;
                        }
                    };
                    results.add(result2);
                }
            } else if (member instanceof OCDesignatedInitializer) {
                OCExpression initializer;
                OCDesignatedInitializer fieldInitializer = (OCDesignatedInitializer)member;
                OCSymbol symbol = fieldInitializer.getDesignation().resolveToSymbol();
                if (symbol != null && (initializer = fieldInitializer.getInitializer()) != null) {
                    OCType rType = initializer.getResolvedType().getGuessedType();
                    results.add(symbol.getResolvedType(this.myContext).checkCompatible(rType, initializer, initializer, true, this.myContext));
                }
            } else {
                results.add(OCTypeCheckResult.createError());
            }
            ++curInitializerIndex;
        }
        return OCCompoundInitializerChecker.combine(results);
    }

    private static String getDebugLocation(@NotNull OCElement e) {
        PsiFile file2 = e.getContainingFile();
        Document d = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        int line = d != null ? d.getLineNumber(e.getTextOffset()) + 1 : -1;
        return file2.getName() + ":" + line;
    }

    public static OCTypeCheckResult combine(List<OCTypeCheckResult> results) {
        if (results.size() == 1) {
            return results.get(0);
        }
        OCTypeCheckState worst = results.stream().map(result2 -> result2.getState()).max(Comparator.comparingInt(Enum::ordinal)).orElse(OCTypeCheckState.OK);
        OCTypeCheckResult result3 = new OCTypeCheckResult(worst);
        return result3;
    }
}

