/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.ArcAnnotatedType;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCReferenceTypeFull;
import com.jetbrains.cidr.lang.types.OCReferenceTypeSimple;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCReferenceType
extends OCType
implements Serializable,
ArcAnnotatedType {
    @NotNull
    private OCSymbolReference myReference;
    private boolean myIsKindof;
    private boolean myFunctionParameterType = false;

    @NotNull
    public static OCReferenceType create(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, String @NotNull [] protocolNames, @NotNull OCTypeSubstitution substitution2, @Nullable ARCAttribute arcAttribute, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        if (protocolNames.length == 0 && substitution2 == OCTypeSubstitution.ID && arcAttribute == null) {
            return new OCReferenceTypeSimple(reference, isConst, isVolatile, nullability, functionParameterType, isKindof);
        }
        return new OCReferenceTypeFull(isConst, isVolatile, reference, protocolNames, substitution2, arcAttribute, nullability, functionParameterType, isKindof);
    }

    protected OCReferenceType() {
    }

    protected OCReferenceType(boolean isConst, boolean isVolatile, @NotNull OCSymbolReference reference, @Nullable OCNullability nullability, boolean functionParameterType, boolean isKindof) {
        super(isConst, isVolatile, nullability);
        this.myReference = reference;
        this.myFunctionParameterType = functionParameterType;
        this.myIsKindof = isKindof;
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitReferenceType(this);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceType f = (OCReferenceType)first;
        OCReferenceType s = (OCReferenceType)second;
        if (f.getARCAttribute() != s.getARCAttribute()) {
            return false;
        }
        if (f.myIsKindof != s.myIsKindof) {
            return false;
        }
        if (!Arrays.equals(f.getProtocolNames(), s.getProtocolNames())) {
            return false;
        }
        if (!c.equalObjects(f.myReference, s.myReference)) {
            return false;
        }
        return c.equalObjects(f.getSubstitution(), s.getSubstitution());
    }

    @Override
    public int hashCode() {
        int result2 = this.baseHashCode();
        result2 = 31 * result2 + this.myReference.hashCode();
        result2 = 31 * result2 + Objects.hashCode((Object)this.getARCAttribute());
        result2 = 31 * result2 + Arrays.hashCode(this.getProtocolNames());
        result2 = 31 * result2 + this.getSubstitution().hashCode();
        result2 = 31 * result2 + Boolean.valueOf(this.myIsKindof).hashCode();
        return result2;
    }

    public abstract String @NotNull [] getProtocolNames();

    @Override
    public boolean isUnknown() {
        return true;
    }

    @Override
    public boolean isUnresolved(@NotNull OCResolveContext context2) {
        return true;
    }

    @NotNull
    public abstract OCTypeSubstitution getSubstitution();

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull PsiElement context2) {
        return OCReferenceType.fromText(name).resolve(context2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull OCResolveContext context2) {
        return OCReferenceType.fromText(name).resolve(context2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull String protocolName, @NotNull PsiElement context2) {
        return OCReferenceType.fromText(name, protocolName).resolve(context2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull String protocolName, @NotNull OCResolveContext context2) {
        return OCReferenceType.fromText(name, protocolName).resolve(context2);
    }

    @NotNull
    public static OCType resolvedFromText(String name, @NotNull OCResolveContext context2, boolean ignoreImports) {
        return OCReferenceType.fromText(name).resolve(context2, ignoreImports);
    }

    @NotNull
    public static OCReferenceType fromText(String name) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name, @NotNull String protocolName) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setSingleProtocolName(protocolName).build();
    }

    @NotNull
    public static OCReferenceType fromText(String name, String @NotNull [] protocolNames) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(OCQualifiedName.interned(name))).setProtocolNames(protocolNames).build();
    }

    public static OCReferenceType fromQualifiedName(OCQualifiedName name) {
        return new OCReferenceTypeBuilder(OCSymbolReference.getDummyGlobalReference(name)).build();
    }

    @NotNull
    public abstract OCReferenceType cloneWithReference(@NotNull OCSymbolReference var1);

    @NotNull
    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @NotNull
    public OCSymbolReference getReference(@NotNull OCResolveContext context2) {
        return this.getReference(context2.getFile());
    }

    @NotNull
    public OCSymbolReference getReference(@Nullable PsiFile file2) {
        return this.getReference(!(file2 instanceof OCFile) || ((OCFile)file2).getKind().isObjC());
    }

    @NotNull
    public OCSymbolReference getReference(boolean maybeObjC) {
        return this.myReference;
    }

    @Override
    protected String getBestNameInContext(@NotNull OCResolveContext context2, @Nullable String nameHint, int templateDepth) {
        if (nameHint == null) {
            nameHint = CVQualifiers.appendCVQualifiers(this.myReference.getQualifiedName().getFullName(context2), this, context2.getProject());
        }
        return super.getBestNameInContext(context2, nameHint, templateDepth);
    }

    @Override
    @Nullable
    public abstract ARCAttribute getARCAttribute();

    @Override
    @NotNull
    public OCReferenceType cloneWithArcAttribute(@Nullable ARCAttribute arcAttribute) {
        return OCReferenceType.create(this.isConst(), this.isVolatile(), this.getReference(), this.getProtocolNames(), this.getSubstitution(), arcAttribute, this.getNullability(), this.isFunctionParameterType(), this.isKindof());
    }

    public boolean isFunctionParameterType() {
        return this.myFunctionParameterType;
    }

    public void setFunctionParameterType(boolean functionParameterType) {
        this.myFunctionParameterType = functionParameterType;
    }

    public boolean isKindof() {
        return this.myIsKindof;
    }

    public boolean hasElaboratedTypeSpecifier() {
        return OCSymbolReference.removeTypeToken((String)this.myReference.getQualifiedName().getName()).typeToken != null;
    }
}

