/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParserRollbacksDebugHighlightingPass
extends TextEditorHighlightingPass {
    private List<HighlightInfo> myInfos = null;

    protected OCParserRollbacksDebugHighlightingPass(@NotNull Project project2, @NotNull Document document2) {
        super(project2, document2);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(this.myProject);
        if (!Registry.is((String)"cidr.debug.show.parser.rollbacks") || !cache.areSymbolsLoaded()) {
            return;
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
        if (!(file2 instanceof OCFile)) {
            return;
        }
        cache.ensurePendingFilesProcessed();
        List<FileSymbolTable> allTables = cache.allTablesForFile((OCFile)file2);
        if (allTables.isEmpty()) {
            return;
        }
        List<ConsumedTokenRange> count = allTables.get(0).getConsumedTokenRanges();
        if (count != null) {
            for (ConsumedTokenRange token : count) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(token.begin, token.end).textAttributes(new TextAttributes(null, OCParserRollbacksDebugHighlightingPass.getBackgroundColor(token.getConsumedCount()), null, null, 0)).create();
                if (info == null) continue;
                infos.add(info);
            }
        }
        this.myInfos = infos;
    }

    public void doApplyInformationToEditor() {
        if (this.myInfos == null) {
            return;
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), this.myInfos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    @Nullable
    private static Color getBackgroundColor(int count) {
        if (count <= 0) {
            return Color.GREEN;
        }
        if (count == 1) {
            return null;
        }
        int numTones = 5;
        int lightness = Math.max(0, 255 - 255 / (numTones + 1) * (count - 1));
        return new Color(255, lightness, lightness);
    }

    public static class Factory
    implements TextEditorHighlightingPassFactory,
    TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, true, -1);
        }

        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            if (!OCLanguageUtils.isSupported(file2)) {
                return null;
            }
            return new OCParserRollbacksDebugHighlightingPass(file2.getProject(), editor.getDocument());
        }
    }
}

