/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCImplementationSymbol
extends OCClassSymbolImpl {
    public OCImplementationSymbol() {
    }

    public OCImplementationSymbol(@Nullable VirtualFile file2, long offset, @NotNull String name, @NotNull List<String> attributes, @Nullable String category, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @Nullable OCReferenceType superType) {
        super(file2, offset, name, attributes, category, members, Collections.emptyList(), superType);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.IMPLEMENTATION;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol(@NotNull Project project2) {
        return this.getInterface(project2);
    }

    @Override
    public boolean isDefinition() {
        return true;
    }

    @Override
    @NotNull
    public OCType getType() {
        return OCReferenceType.fromText(this.getName());
    }

    @Override
    @Nullable
    public OCInterfaceSymbol getInterface(@NotNull Project project2) {
        OCInterfaceSymbol symbol = this.getInterface(false, this.getCategoryName(), project2);
        if (symbol == null && this.getCategoryName() != null) {
            symbol = this.getInterface(false, null, project2);
        }
        return symbol;
    }

    @Nullable
    public OCInterfaceSymbol getInterface(boolean ignoringImports, @Nullable String categoryName, @NotNull Project project2) {
        final Condition condition = symbol -> symbol instanceof OCInterfaceSymbol && !symbol.isPredeclaration() && Objects.equals(categoryName, ((OCInterfaceSymbol)symbol).getCategoryName());
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return condition.value((Object)symbol);
            }
        };
        OCFile containingFile = this.getContainingOCFile(project2);
        if (containingFile == null) {
            return null;
        }
        String name = this.getName();
        OCResolveUtil.processGlobalSymbols(name, null, containingFile, this.getOffset(), (Processor<OCSymbol>)processor2);
        if (!processor2.isFound() && ignoringImports) {
            return (OCInterfaceSymbol)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, name, (Condition<? super OCSymbol>)condition, this.myFile);
        }
        return (OCInterfaceSymbol)processor2.getFoundValue();
    }

    @Override
    public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        return this.getInterface(project2);
    }

    @Override
    public OCImplementationSymbol getImplementation(@NotNull Project project2) {
        return this;
    }
}

