/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnaryExpressionSymbolBase
extends OCExpressionSymbol {
    protected OCElementType myOperator;
    protected OCExpressionSymbol myOperand;

    public OCUnaryExpressionSymbolBase() {
    }

    public OCUnaryExpressionSymbolBase(@Nullable VirtualFile file2, long offset, @NotNull OCElementType operator, @NotNull OCExpressionSymbol operand) {
        super(file2, offset);
        this.myOperator = operator;
        this.myOperand = operand;
    }

    @NotNull
    public abstract OCOperatorReference.OperatorPlacement getOperatorPlacement();

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCUnaryExpressionSymbolBase firstSymbol = (OCUnaryExpressionSymbolBase)first;
        OCUnaryExpressionSymbolBase secondSymbol = (OCUnaryExpressionSymbolBase)second;
        if (firstSymbol.myOperator != secondSymbol.myOperator) {
            return false;
        }
        return c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalUnary(this.myOperator, this.myOperand.evaluate(evaluator));
    }

    protected abstract OCType getResolvedType(OCType var1, @NotNull OCResolveContext var2);

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        OCFunctionSymbol symbol;
        OCType opType = this.myOperand.getResolvedType(context2);
        if (opType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if ((symbol = OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context2)) != null) {
            return symbol.getType().getReturnType().resolve(context2);
        }
        return this.getResolvedType(opType, context2);
    }

    @Nullable
    public OCType getCustomReturnType(@NotNull OCResolveContext context2) {
        return this.getInfo((OCResolveContext)context2).customReturnType;
    }

    @NotNull
    private Info getInfo(@NotNull OCResolveContext context2) {
        OCFunctionSymbol symbol;
        OCType opType = this.myOperand.getResolvedType(context2);
        OCType customReturnType = null;
        if (opType != null && (symbol = this.tryResolveOperator(context2, opType)) != null) {
            customReturnType = symbol.getType().getReturnType().resolve(context2);
        }
        return new Info(opType, customReturnType);
    }

    @Nullable
    public OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context2) {
        OCType opType = this.myOperand.getResolvedType(context2);
        return this.tryResolveOperator(context2, opType);
    }

    @Nullable
    private OCFunctionSymbol tryResolveOperator(@NotNull OCResolveContext context2, @Nullable OCType opType) {
        if (opType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)opType).getSymbol());
        }
        if (opType != null) {
            return OCOperatorReference.resolveOperator(this.myOperator.getName(), this.getOperatorPlacement(), Collections.singletonList(opType), Collections.singletonList(this.myOperand), context2);
        }
        return null;
    }

    public OCElementType getOperator() {
        return this.myOperator;
    }

    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myOperator.getName() + this.myOperand.getPresentableName();
    }

    private static class Info {
        @Nullable
        public final OCType opType;
        @Nullable
        public final OCType customReturnType;

        private Info(@Nullable OCType opType, @Nullable OCType customReturnType) {
            this.opType = opType;
            this.customReturnType = customReturnType;
        }
    }
}

