/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCastExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myOperand;
    private OCType myType;
    private OCCastKind myCastKind;

    public OCCastExpressionSymbol() {
    }

    public OCCastExpressionSymbol(@Nullable VirtualFile file2, long offset, @Nullable OCExpressionSymbol operand, @NotNull OCType type, @NotNull OCCastKind castKind) {
        super(file2, offset);
        this.myOperand = operand;
        this.myType = type;
        this.myCastKind = castKind;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCastExpressionSymbol firstSymbol = (OCCastExpressionSymbol)first;
        OCCastExpressionSymbol secondSymbol = (OCCastExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myOperand, secondSymbol.myOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myType, secondSymbol.myType);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return this.myOperand != null ? (T)evaluator.evalCast(this.myType, this.myOperand.evaluate(evaluator)) : null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        OCType castType = this.myType.resolve(context2);
        if (castType instanceof OCStructType && this.myOperand instanceof OCInitializerListExpressionSymbol) {
            OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(Collections.singletonList(this.myOperand), context2);
            return OCTypeUtils.deduceClassTemplateArguments((OCStructType)castType, this.myType, arguments, true, context2, this.getContainingFile(), this.getComplexOffset());
        }
        return castType;
    }

    @NotNull
    public OCType getCastType() {
        return this.myType;
    }

    @Nullable
    public OCExpressionSymbol getOperand() {
        return this.myOperand;
    }

    @NotNull
    public OCCastKind getCastKind() {
        return this.myCastKind;
    }

    @Contract(value="null -> false")
    public static boolean isConstCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.CONST_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isReinterpretCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.REINTERPRET_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isDynamicCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.DYNAMIC_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isStaticCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.STATIC_CAST;
    }

    @Contract(value="null -> false")
    public static boolean isCStyleCast(OCExpressionSymbol expr) {
        return expr instanceof OCCastExpressionSymbol && ((OCCastExpressionSymbol)expr).getCastKind() == OCCastKind.C_STYLE_CAST;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "(" + this.myType.getName() + ")" + (this.myOperand != null ? this.myOperand.getPresentableName() : "...");
    }
}

