/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.ui.NonFocusableCheckBox;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.PropertyKey;

public class OCBooleanOption
implements OCOption<Boolean, JCheckBox> {
    private String myCaption;

    public OCBooleanOption(String caption) {
        this.myCaption = caption;
    }

    @Override
    public JCheckBox createComponent() {
        NonFocusableCheckBox checkBox = new NonFocusableCheckBox(this.myCaption);
        if (this.myCaption.startsWith("Show ")) {
            checkBox.setMnemonic(this.myCaption.charAt("Show ".length()));
        } else {
            checkBox.setMnemonic(this.myCaption.charAt(0));
        }
        return checkBox;
    }

    @Override
    public Boolean getSelectedValue(JCheckBox component) {
        return component.isSelected();
    }

    @Override
    public void selectValue(JCheckBox component, Boolean value) {
        component.setSelected(value);
    }

    @Override
    public void addItemListener(JCheckBox component, ItemListener listener) {
        component.addItemListener(listener);
    }

    public static void setStates(JCheckBox component, boolean state1, @PropertyKey(resourceBundle="messages.OCBundle") String key1, boolean state2, @PropertyKey(resourceBundle="messages.OCBundle") String key2) {
        component.setEnabled(!state1 && !state2);
        if (state1) {
            component.setSelected(false);
            component.setText(OCBundle.message(key1, new Object[0]));
        } else if (state2) {
            component.setSelected(true);
            component.setText(OCBundle.message(key2, new Object[0]));
        }
    }
}

