/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCConstructorInEmptyInitializationUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCExternalReferenceUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCFunctionUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCMethodDotCallUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCPropertyAttributeUsage;
import com.jetbrains.cidr.lang.refactoring.changeSignature.usages.OCSelectorExpressionUsage;
import com.jetbrains.cidr.lang.search.FileNameWithoutExtensionIndex;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchHelper;
import com.jetbrains.cidr.lang.search.constructors.OCBaseConstructorReference;
import com.jetbrains.cidr.lang.search.constructors.OCConstructorImplicitReferenceSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchUtil {
    private static final Map<String, Integer> EXTENSION_ORDER = new HashMap<String, Integer>();

    @NotNull
    public static Collection<VirtualFile> getProjectVirtualFilesByName(@NotNull Project project2, @NotNull String name) {
        return FilenameIndex.getVirtualFilesByName((Project)project2, (String)name, (boolean)SystemInfo.isFileSystemCaseSensitive, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getProjectOCFilesByName(@NotNull Project project2, @NotNull String name) {
        return OCSearchUtil.getOCFilesByName(project2, name, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    public static List<OCFile> getOCFilesByName(@NotNull Project project2, @NotNull String name, @NotNull GlobalSearchScope scope) {
        return ContainerUtil.filter((Object[])FilenameIndex.getFilesByName((Project)project2, (String)name, (GlobalSearchScope)scope), (Condition)new FilteringIterator.InstanceOf(OCFile.class));
    }

    @Nullable
    public static VirtualFile getAssociatedFileWithSameName(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        ArrayList filesWithScores = new ArrayList();
        OCSearchUtil.processAssociatedFilesWithSameName(project2, virtualFile, (Processor<? super VirtualFile>)((Processor)file2 -> {
            int score;
            Integer order = EXTENSION_ORDER.get(OCSearchUtil.getLowerCaseExtension(file2));
            int n = score = order == null ? 0 : order;
            if (Comparing.equal((Object)virtualFile.getParent(), (Object)file2.getParent())) {
                score += 1000;
            } else if (OCSearchHelper.areFromSameProject(project2, virtualFile, file2)) {
                score += 500;
            }
            filesWithScores.add(Pair.create((Object)file2, (Object)score));
            return true;
        }));
        if (filesWithScores.isEmpty()) {
            return null;
        }
        return (VirtualFile)((Pair)Collections.max(filesWithScores, (Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$getAssociatedFileWithSameName$1(com.intellij.openapi.util.Pair com.intellij.openapi.util.Pair ), (Lcom/intellij/openapi/util/Pair;Lcom/intellij/openapi/util/Pair;)I)())).first;
    }

    public static void processAssociatedFilesWithSameName(@NotNull Project project2, @NotNull VirtualFile virtualFile, @NotNull Processor<? super VirtualFile> processor2) {
        HashSet<String> associatedExts;
        String name = virtualFile.getName();
        if (OCFileTypeHelpers.isHeaderFile(name)) {
            associatedExts = new HashSet<String>(OCFileTypeHelpers.sourceExtensions());
        } else if (OCFileTypeHelpers.isSourceFile(name)) {
            associatedExts = new HashSet<String>(OCFileTypeHelpers.headerExtensions());
            associatedExts.remove("pch");
        } else {
            return;
        }
        String nameNoExtension = FileUtilRt.getNameWithoutExtension((String)name);
        FileBasedIndex.ValueProcessor extensionFilter = (file2, value) -> {
            if (!file2.isDirectory() && associatedExts.contains(OCSearchUtil.getLowerCaseExtension(file2))) {
                return processor2.process((Object)file2);
            }
            return true;
        };
        FileNameWithoutExtensionIndex.processFiles(nameNoExtension, (FileBasedIndex.ValueProcessor<Void>)extensionFilter, GlobalSearchScope.projectScope((Project)project2));
    }

    @NotNull
    private static String getLowerCaseExtension(@NotNull VirtualFile file2) {
        return StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)file2.getName()));
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, @NotNull Project project2) {
        return OCSearchUtil.processMembersHierarchy(member, processor2, searchAncestors, searchInheritors, true, project2);
    }

    public static <T extends OCSymbolWithParent> boolean processMembersHierarchy(@Nullable T member, @NotNull Processor<? super T> processor2, boolean searchAncestors, boolean searchInheritors, boolean includeSameSymbols, Project project2) {
        if (member instanceof OCFunctionSymbol) {
            OCFile file2 = member.getContainingOCFile(project2);
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)member;
            if (searchInheritors && file2 != null) {
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(functionSymbol, file2, true);
                parameters.setIncludeSameSymbols(includeSameSymbols);
                parameters.setIncludeFriendsInResults(functionSymbol.isFriend());
                if (!OCFunctionInheritorsSearch.search(parameters).forEach(processor2)) {
                    return false;
                }
            }
            if (searchAncestors && !new OCFunctionAncestorsQuery(functionSymbol, true, includeSameSymbols, project2).forEach(processor2)) {
                return false;
            }
        }
        if (member instanceof OCMemberSymbol) {
            OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)member, project2);
            parameters.setIncludeSelfImplementation(includeSameSymbols);
            parameters.setInheritors(searchInheritors);
            parameters.setAncestors(searchAncestors);
            if (!OCMemberInheritorsSearch.search(parameters).forEach(processor2)) {
                return false;
            }
        }
        return true;
    }

    public static boolean processMembersHierarchyPsi(@Nullable OCSymbolWithParent member, @NotNull Processor<? super PsiElement> processor2, boolean searchAncestors, boolean searchInheritors, @NotNull Project project2) {
        return OCSearchUtil.processMembersHierarchy(member, symbol -> {
            PsiElement overridingMethod = symbol.locateDefinition(project2);
            if (overridingMethod instanceof OCDeclarator) {
                overridingMethod = overridingMethod.getParent();
            }
            if (overridingMethod != null) {
                return processor2.process((Object)overridingMethod);
            }
            return true;
        }, searchAncestors, searchInheritors, project2);
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project2) {
        AncestorBuilder result2 = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            result2.symbol = symbol;
            if (!OCSearchScope.isInProjectSources(symbol, project2)) {
                result2.isOutOfProject = true;
                return false;
            }
            return true;
        }, true, false, false, project2);
        return result2.getAncestor();
    }

    @Nullable
    @Contract(value="null,_ -> null; !null,_ -> _")
    public static Ancestor findSomeInProjectAncestor(@Nullable OCSymbolWithParent member, @NotNull Project project2) {
        AncestorBuilder result2 = new AncestorBuilder();
        OCSearchUtil.processMembersHierarchy(member, symbol -> {
            if (OCSearchScope.isInProjectSources(symbol, project2)) {
                result2.symbol = symbol;
                return false;
            }
            return true;
        }, true, false, false, project2);
        return result2.getAncestor();
    }

    public static boolean processMemberAncestors(@Nullable OCSymbolWithParent member, @NotNull Processor<? super OCSymbolWithParent> processor2, boolean onlyDeclarations, @NotNull Project project2) {
        return OCSearchUtil.processMembersHierarchy(member, ancestor -> {
            if (onlyDeclarations && ancestor.isDefinition() && OCSearchUtil.getFirstPredeclaration(ancestor, project2) != null || ancestor.equals(member)) {
                return true;
            }
            return processor2.process(ancestor);
        }, true, false, true, project2);
    }

    public static boolean findAllMemberUsages(@Nullable OCSymbolWithParent member, @NotNull Set<? super UsageInfo> result2, boolean searchInheritors, boolean searchAncestors, @NotNull Project project2) {
        return OCSearchUtil.processMembersHierarchyPsi(member, (Processor<? super PsiElement>)((Processor)element -> {
            OCSearchUtil.findOneMethodUsages(element, result2);
            return true;
        }), searchAncestors, searchInheritors, project2);
    }

    public static void findOneMethodUsages(@NotNull PsiElement method, @NotNull Set<? super UsageInfo> result2) {
        GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(method.getProject());
        if (method instanceof OCFunctionDeclaration) {
            OCDeclarator declarator = ((OCFunctionDeclaration)method).getDeclarator();
            if (declarator != null) {
                for (PsiReference ref : ReferencesSearch.search((PsiElement)declarator, (SearchScope)scope).findAll()) {
                    if (ref.getElement() == null || !OCLanguageUtils.getSlowLanguage().equals(ref.getElement().getLanguage())) continue;
                    result2.add(new OCFunctionUsage(ref));
                }
                ArrayList<OCConstructorInEmptyInitializationUsage> ctorUsages = new ArrayList<OCConstructorInEmptyInitializationUsage>();
                for (PsiReference ref : OCConstructorImplicitReferenceSearch.search(declarator, (SearchScope)scope)) {
                    ctorUsages.add(new OCConstructorInEmptyInitializationUsage((OCBaseConstructorReference)ref));
                }
                ctorUsages.sort(Comparator.comparing(u -> u.getCtorReference().getField().getTextOffset()));
                result2.addAll(ctorUsages);
            }
        } else if (method instanceof OCMethod) {
            Processor consumer = psiReference -> {
                if (psiReference instanceof OCExternalReference) {
                    result2.add(new OCExternalReferenceUsage((OCExternalReference)psiReference));
                    return true;
                }
                PsiElement element = psiReference.getElement();
                if (element instanceof OCSendMessageExpression) {
                    result2.add(new OCMethodCallUsage((PsiReference)psiReference));
                } else if (element instanceof OCSelectorExpression) {
                    result2.add(new OCSelectorExpressionUsage((PsiReference)psiReference));
                } else if (element instanceof OCPropertyAttribute) {
                    result2.add(new OCPropertyAttributeUsage((PsiReference)psiReference));
                } else if (element instanceof OCQualifiedExpression) {
                    result2.add(new OCMethodDotCallUsage((PsiReference)psiReference));
                }
                return true;
            };
            ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).forEach(consumer);
        }
    }

    public static boolean hasRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        Ref result2 = Ref.create((Object)false);
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (s instanceof OCStructSymbol && !s.isPredeclaration() && !symbol.equals(s)) {
                result2.set((Object)true);
                return false;
            }
            return true;
        }), project2);
        return (Boolean)result2.get();
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        return OCSearchUtil.getRelatedSymbols(symbol, false, project2);
    }

    @NotNull
    public static List<OCSymbol> getRelatedSymbols(@NotNull OCStructSymbol symbol, boolean excludeProcessingSymbol, @NotNull Project project2) {
        ArrayList<OCSymbol> result2 = new ArrayList<OCSymbol>();
        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
            if (excludeProcessingSymbol && symbol.equals(s)) {
                return true;
            }
            if (s instanceof OCStructSymbol && !s.isPredeclaration()) {
                if (((OCStructSymbol)s).isSpecialization()) {
                    if (!s.isPredeclaration()) {
                        result2.add((OCSymbol)s);
                    }
                } else {
                    result2.add(0, (OCSymbol)s);
                }
            }
            return true;
        }), project2);
        return result2;
    }

    public static boolean processPredeclarations(@NotNull OCSymbol symbol, @NotNull Processor<? super OCSymbol> processor2, @NotNull Project project2) {
        return symbol.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(s -> s.isPredeclaration(), processor2), project2);
    }

    @Nullable
    public static OCSymbol getFirstPredeclaration(@NotNull OCSymbol symbol, @NotNull Project project2) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCSearchUtil.processPredeclarations(symbol, (Processor<? super OCSymbol>)finder, project2);
        return (OCSymbol)finder.getFoundValue();
    }

    private static /* synthetic */ int lambda$getAssociatedFileWithSameName$1(Pair o1, Pair o2) {
        return Comparing.compare((Comparable)((Comparable)o1.second), (Comparable)((Comparable)o2.second));
    }

    static {
        ArrayList<String> extensions = new ArrayList<String>(OCFileTypeHelpers.sourceExtensions());
        extensions.addAll(OCFileTypeHelpers.headerExtensions());
        Collections.sort(extensions);
        int size = extensions.size();
        for (int i2 = 0; i2 < size; ++i2) {
            String e = extensions.get(i2);
            EXTENSION_ORDER.put(e, size - i2);
        }
    }

    private static class AncestorBuilder {
        @Nullable
        private OCSymbolWithParent symbol;
        private boolean isOutOfProject;

        private AncestorBuilder() {
        }

        @Nullable
        private Ancestor getAncestor() {
            return this.symbol != null ? new Ancestor(this.symbol, this.isOutOfProject) : null;
        }
    }

    public static class Ancestor {
        @NotNull
        private final OCSymbolWithParent symbol;
        private final boolean isOutOfProject;

        private Ancestor(@NotNull OCSymbolWithParent symbol, boolean isOutOfProject) {
            this.symbol = symbol;
            this.isOutOfProject = isOutOfProject;
        }

        @NotNull
        public OCSymbolWithParent getSymbol() {
            return this.symbol;
        }

        public boolean isOutOfProject() {
            return this.isOutOfProject;
        }
    }
}

