/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCIfUnwrapper
extends OCUnwrapper {
    public OCIfUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.if", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof OCIfStatement && !OCIfUnwrapper.isElseBlock(e);
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context2) {
        OCStatement then;
        OCDeclaration decl;
        OCIfStatement ifStmt = (OCIfStatement)element;
        OCCondition condition = ifStmt.getCondition();
        boolean ifHasDeclaration = false;
        if (condition != null && condition.getDeclaration() != null && (decl = condition.getDeclaration()).getParent() instanceof OCDeclarationStatement) {
            OCDeclarationStatement declStmt = (OCDeclarationStatement)decl.getParent();
            context2.extractElement(declStmt, ifStmt);
            ifHasDeclaration = true;
        }
        if ((then = ifStmt.getThenBranch()) != null) {
            if (ifHasDeclaration) {
                context2.addSemicolonBefore(ifStmt);
                context2.addNewLineBefore(ifStmt);
            }
            context2.extractFromBlockOrSingleStatement(then, ifStmt);
        }
        context2.delete(ifStmt);
    }
}

