/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class OCElseUnwrapperBase
extends OCUnwrapper {
    public OCElseUnwrapperBase(String description2) {
        super(description2);
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return OCElseUnwrapperBase.isElseBlock(e) || this.isElseKeyword(e) && this.isValidElseBranch(e);
    }

    public void collectElementsToIgnore(@NotNull PsiElement element, @NotNull Set<PsiElement> result2) {
        PsiElement parent = element.getParent();
        while (parent instanceof OCIfStatement) {
            result2.add(parent);
            parent = parent.getParent();
        }
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context2) throws IncorrectOperationException {
        OCStatement elseBranch = this.isElseKeyword(element) ? ((OCIfStatement)element.getParent()).getElseBranch() : (OCStatement)element;
        this.doUnwrapElse(elseBranch, context2);
    }

    protected boolean isElseIfBranch(OCStatement elseBranch) {
        return elseBranch instanceof OCIfStatement;
    }

    protected boolean isElseKeyword(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof OCIfStatement && e.getNode() == ((OCIfStatement)p).getElseKeyword();
    }

    protected abstract void doUnwrapElse(OCStatement var1, OCUnwrapper.Context var2) throws IncorrectOperationException;

    private boolean isValidElseBranch(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof OCIfStatement && ((OCIfStatement)p).getElseBranch() != null;
    }
}

