/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCBracesUnwrapper
extends OCUnwrapper {
    public OCBracesUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.braces", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof OCBlockStatement && !this.belongsToControlStructures(e) && !this.isTopLevelBlock(e);
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context2) throws IncorrectOperationException {
        context2.extractFromBlockOrSingleStatement((OCBlockStatement)element, element);
        context2.delete(element);
    }

    private boolean belongsToControlStructures(PsiElement e) {
        PsiElement p = e.getParent();
        return p instanceof OCIfStatement || p instanceof OCSwitchStatement || p instanceof OCLoopStatement || p instanceof OCTryStatement || p instanceof OCCatchSection;
    }

    private boolean isTopLevelBlock(PsiElement e) {
        while (e.getParent() != null) {
            PsiElement parent = e.getParent();
            if (parent instanceof OCBlockStatement) {
                return false;
            }
            if (parent instanceof OCLambdaExpression || parent instanceof OCFile) break;
            e = parent;
        }
        return true;
    }
}

