/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.changeSignature;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCParameterTableModel
extends ParameterTableModelBase<OCParameterInfo, ParameterTableModelItemBase<OCParameterInfo>> {
    public OCParameterTableModel(PsiElement context2, boolean useSelectors) {
        super(context2, context2, OCParameterTableModel.getColumns(context2.getProject(), useSelectors));
    }

    private static ColumnInfo[] getColumns(Project project2, boolean useSelectors) {
        if (useSelectors) {
            return new ColumnInfo[]{new SelectorColumn(project2), new ParameterTableModelBase.TypeColumn(project2, (FileType)OCFileType.INSTANCE), new ParameterTableModelBase.NameColumn(project2), new ParameterTableModelBase.DefaultValueColumn(project2, (FileType)OCFileType.INSTANCE)};
        }
        return new ColumnInfo[]{new ParameterTableModelBase.TypeColumn(project2, (FileType)OCFileType.INSTANCE), new ParameterTableModelBase.NameColumn(project2), new ParameterTableModelBase.DefaultValueColumn(project2, (FileType)OCFileType.INSTANCE)};
    }

    public void updateColumns(Project project2, boolean useSelectors) {
        this.setColumnInfos(OCParameterTableModel.getColumns(project2, useSelectors));
    }

    protected ParameterTableModelItemBase<OCParameterInfo> createRowItem(@Nullable OCParameterInfo parameterInfo) {
        if (parameterInfo == null) {
            parameterInfo = new OCParameterInfo("", "", null, -1, this.myTypeContext);
        }
        final boolean isEllipsisType = parameterInfo.isEllipsisType();
        OCType type = parameterInfo.getType();
        String typeName = "";
        if (type != null) {
            typeName = type.getClass().equals(OCPointerType.class) && ((OCPointerType)type).isArrayLikeParameter() ? parameterInfo.getTypeText() : type.getBestNameInContext(this.myTypeContext, parameterInfo.getTypeText());
        }
        Project project2 = this.myTypeContext.getProject();
        OCCodeFragment typeCodeFragment = OCElementFactory.getTypeCodeFragmentInWriteAction(typeName, project2, this.myTypeContext);
        OCCodeFragment defaultValueCodeFragment = OCElementFactory.codeFragment(StringUtil.notNullize((String)parameterInfo.getDefaultValue()), project2, this.myTypeContext, true, false);
        return new ParameterTableModelItemBase<OCParameterInfo>(parameterInfo, (PsiCodeFragment)typeCodeFragment, (PsiCodeFragment)defaultValueCodeFragment){

            public boolean isEllipsisType() {
                return isEllipsisType;
            }
        };
    }

    public void addFirstRow(OCParameterInfo parameterInfo) {
        ArrayList<ParameterTableModelItemBase<OCParameterInfo>> items = new ArrayList<ParameterTableModelItemBase<OCParameterInfo>>();
        items.add(this.createRowItem(parameterInfo));
        items.addAll(this.getItems());
        this.setItems(items);
    }

    public void addLastRow(OCParameterInfo parameterInfo) {
        this.addRow(this.createRowItem(parameterInfo));
    }

    public void addRow(OCParameterInfo parameterInfo, int index) {
        ArrayList<ParameterTableModelItemBase<OCParameterInfo>> items = new ArrayList<ParameterTableModelItemBase<OCParameterInfo>>(this.getItems());
        items.add(index, this.createRowItem(parameterInfo));
        this.setItems(items);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAtWithoutUpdate(aValue, rowIndex, columnIndex);
    }

    public void exchangeRows(int idx1, int idx2) {
        if (idx1 == 0 && idx2 != 0) {
            OCParameterInfo firstParam = (OCParameterInfo)((ParameterTableModelItemBase)this.getItem((int)idx1)).parameter;
            OCParameterInfo secondParam = (OCParameterInfo)((ParameterTableModelItemBase)this.getItem((int)idx2)).parameter;
            String firstName = OCNameSuggester.getSelectorNameWithoutParameter(firstParam.getSelector(), firstParam.getName()) + StringUtil.capitalize((String)OCNameSuggester.removeSelectorPrefixes(secondParam.getSelector()));
            String secondName = OCNameSuggester.removeVariablePrefixes(firstParam.getName());
            secondParam.setSelector(firstName);
            firstParam.setSelector(secondName);
        } else if (idx2 == 0 && idx1 != 0) {
            this.exchangeRows(idx2, idx1);
            return;
        }
        super.exchangeRows(idx1, idx2);
    }

    public void removeRow(int idx) {
        this.removeRow(idx, true);
    }

    public void removeRow(int idx, boolean mergeFirstSelector) {
        if (mergeFirstSelector && idx == 0 && this.getRowCount() > 1) {
            OCParameterInfo firstParam = (OCParameterInfo)((ParameterTableModelItemBase)this.getItem((int)0)).parameter;
            OCParameterInfo secondParam = (OCParameterInfo)((ParameterTableModelItemBase)this.getItem((int)1)).parameter;
            String newName = OCNameSuggester.getSelectorNameWithoutParameter(firstParam.getSelector(), firstParam.getName()) + StringUtil.capitalize((String)OCNameSuggester.removeSelectorPrefixes(secondParam.getSelector()));
            secondParam.setSelector(newName);
        }
        super.removeRow(idx);
    }

    public static boolean isTypeColumn(ColumnInfo column) {
        return column instanceof ParameterTableModelBase.TypeColumn;
    }

    public static boolean isDefaultValueColumn(@NotNull ColumnInfo column) {
        return column instanceof ParameterTableModelBase.DefaultValueColumn;
    }

    private static class SelectorColumn
    extends ParameterTableModelBase.NameColumn<OCParameterInfo, ParameterTableModelItemBase<OCParameterInfo>> {
        SelectorColumn(Project project2) {
            super(project2);
            this.setName(OCBundle.message("changeSignature.parameter.selector.part", new Object[0]));
        }

        public String valueOf(ParameterTableModelItemBase<OCParameterInfo> item) {
            return ((OCParameterInfo)item.parameter).getSelector();
        }

        public void setValue(ParameterTableModelItemBase<OCParameterInfo> item, String value) {
            ((OCParameterInfo)item.parameter).setSelector(value);
        }
    }
}

