/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiFileRange;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuppressClangForFile
extends OCSuppressClangDiagnosticIntentionAction {
    private SmartPsiFileRange myRange;

    public OCSuppressClangForFile(@Nullable OCFile file2, @Nullable TextRange range, @Nullable OCSuppressionGroup suppressionGroup) {
        super(file2, suppressionGroup, "file");
        if (file2 != null && range != null) {
            this.myRange = SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiFileRangePointer((PsiFile)file2, range);
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiElement element) {
        return super.isAvailable(project2, editor, element) && this.myRange != null;
    }

    @Override
    @Nullable
    protected TextRange getSuppressionRange(OCFile file2) {
        Segment range = this.myRange.getRange();
        if (range == null || range.getEndOffset() > file2.getTextLength()) {
            return null;
        }
        int beforeOffset = range.getStartOffset();
        for (PsiElement child : file2.getChildren()) {
            TextRange childRange = child.getTextRange();
            if (child instanceof OCPragma) {
                OCPragmaSuppressionUtils.Scope scope = OCPragmaSuppressionUtils.findScope(file2, child.getTextOffset());
                TextRange pragmaPush = scope.getPush();
                TextRange pragmaPop = scope.getPop();
                if (pragmaPush != null && pragmaPop != null && pragmaPush.getStartOffset() == child.getTextOffset()) {
                    return new TextRange(pragmaPush.getEndOffset(), pragmaPop.getStartOffset() - 1);
                }
            }
            if ((OCElementUtil.isWhitespace(child) || child instanceof OCIncludeDirective) && childRange.getEndOffset() < beforeOffset && !(child instanceof OCPragma)) continue;
            return new TextRange(childRange.getStartOffset(), file2.getTextLength());
        }
        return file2.getTextRange();
    }
}

