/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCSynthesizePropertyQuickFixBase;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMakePropertyDynamicQuickFix
extends OCSynthesizePropertyQuickFixBase
implements LowPriorityAction {
    public OCMakePropertyDynamicQuickFix(OCImplementationSymbol implementationSymbol, OCPropertySymbol property, Project project2) {
        super(implementationSymbol, property, project2);
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty == null) {
            return OCBundle.message("action.invalid.title", new Object[0]);
        }
        return OCBundle.message("quickfixes.make.property.dynamic", this.myProperty.getNameWithKindLowercase(OCCompilationContext.create(this.myProperty, this.myProject)));
    }

    @Override
    public void invoke(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateIvarsActionContext context2) throws IncorrectOperationException {
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiElement decl = this.myImplementationSymbol.locateDefinition(project2);
        if (!(decl instanceof OCImplementation) || !FileModificationService.getInstance().prepareFileForWrite(decl.getContainingFile())) {
            return;
        }
        OCImplementation implementation = (OCImplementation)decl;
        OCSynthesizePropertiesList declaration = OCElementFactory.synthesizeList("@dynamic", this.myProperty.getName(), null, (PsiElement)file2);
        OCInstanceVariablesList ivars = implementation.getInstanceVariablesList();
        implementation.addBefore(declaration, ivars.getNextSibling());
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            CommandProcessor.getInstance().addAffectedFiles(project2, new VirtualFile[]{virtualFile});
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

