/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCChangeGCCAttributeIntentionAction
extends OCSymbolQuickFix<OCSymbol>
implements LowPriorityAction {
    private String myAttribute;
    private String myAttributeText;
    private boolean myEnable;
    private String myText;

    public OCChangeGCCAttributeIntentionAction(@NotNull OCSymbol symbol, String attribute, String attributeText, boolean enable, @NotNull OCCompilationContext context2) {
        this(symbol, attribute, attributeText, symbol.getNameWithKindLowercase(context2), enable, context2);
    }

    public OCChangeGCCAttributeIntentionAction(@NotNull OCSymbol symbol, String attribute, String attributeText, String subject, boolean enable, @NotNull OCCompilationContext context2) {
        super(context2.getProject(), symbol);
        this.myAttribute = attribute;
        this.myAttributeText = attributeText;
        this.myEnable = enable;
        this.myText = (enable ? "Enable '" : "Disable '") + this.myAttributeText + "' for " + subject;
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable() && this.myEnable ^ this.mySymbol.hasAttribute(this.myAttribute);
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("change.gcc.attribute.action", this.myAttributeText);
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (!OCCodeInsightUtil.isValid(this.mySymbol.locateDefinition(project2))) {
            return;
        }
        ArrayList definitions = new ArrayList();
        this.mySymbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
            PsiElement definition = symbol1.locateDefinition(project2);
            if (definition != null) {
                definitions.add(definition);
            }
            return true;
        }), project2);
        for (PsiElement definition : definitions) {
            this.importFileContainingAttribute(definition);
            int offset = -1;
            if (definition.getParent() instanceof OCDeclaration) {
                PsiElement leaf;
                PsiElement nameIdentifier;
                OCElement footer;
                OCDeclaration declaration = (OCDeclaration)definition.getParent();
                OCTemplateParameterList templateParams = declaration.getTemplateParameterList();
                OCRequiresClause requiresClause = declaration.getRequiresClause();
                OCElement oCElement = footer = requiresClause != null ? requiresClause : templateParams;
                offset = declaration.getParent() instanceof OCEnum && definition instanceof OCDeclarator ? ((nameIdentifier = ((OCDeclarator)definition).getNameIdentifier()) != null ? nameIdentifier.getTextRange().getEndOffset() : declaration.getTextRange().getEndOffset()) : (footer != null ? ((leaf = OCElementUtil.getNextNonWhitespaceCommentLeaf(footer)) != null ? leaf.getTextOffset() : footer.getTextRange().getEndOffset()) : ((leaf = OCElementUtil.getFirstNonWhitespaceCommentLeaf(definition.getParent())) != null ? leaf.getTextOffset() : definition.getParent().getTextRange().getStartOffset()));
            } else if (definition instanceof OCStructLike) {
                PsiElement nameIdentifier = ((OCStructLike)definition).getNameIdentifier();
                offset = nameIdentifier != null ? nameIdentifier.getTextOffset() : definition.getParent().getTextRange().getEndOffset();
            } else if (definition instanceof OCMethod) {
                List<OCMethodSelectorPart> parameters = ((OCMethod)definition).getParameters();
                if (!parameters.isEmpty()) {
                    offset = parameters.get(parameters.size() - 1).getTextRange().getEndOffset();
                }
            } else if (definition instanceof OCMethodSelectorPart) {
                OCTypeElement typeElement = ((OCMethodSelectorPart)definition).getTypeElement();
                if (typeElement != null) {
                    offset = typeElement.getTextOffset();
                }
            } else if (definition instanceof OCLabeledStatement) {
                offset = definition.getTextOffset();
            } else if (definition instanceof OCCppUsingStatement) {
                PsiElement nameIdentifier = ((OCCppUsingStatement)definition).getNameIdentifier();
                offset = nameIdentifier != null ? nameIdentifier.getTextRange().getEndOffset() : definition.getTextOffset();
            } else assert (false) : definition.getClass();
            if (offset == -1) continue;
            if (this.myEnable) {
                OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), offset, 0, " " + this.myAttributeText + " ", true);
                continue;
            }
            int index = definition.getText().indexOf(this.myAttributeText);
            if (index == -1) continue;
            OCChangeUtil.changeText(definition.getProject(), definition.getContainingFile(), definition.getTextRange().getStartOffset() + index, this.myAttributeText.length(), "", true);
        }
    }

    private void importFileContainingAttribute(PsiElement definition) {
        PsiFile file2 = definition.getContainingFile();
        OCResolveContext context2 = OCResolveContext.forPsi((PsiElement)file2);
        context2.setProcessNonImported(true);
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.with(this.myAttributeText));
        List<OCSymbol> unusedSymbols = context2.resolveToSymbols(ref);
        for (OCSymbol unused : unusedSymbols) {
            if (unused.getKind() == OCSymbolKind.MACRO && new OCImportSymbolFix((PsiElement)definition.getContainingFile(), unused).fixBestItem(file2.getProject(), file2)) break;
        }
    }

    public static OCChangeGCCAttributeIntentionAction unused(@NotNull OCSymbol symbol, @NotNull PsiFile file2) {
        return OCChangeGCCAttributeIntentionAction.unused(symbol, symbol.getNameWithKindLowercase(OCCompilationContext.create((PsiElement)file2)), file2);
    }

    public static OCChangeGCCAttributeIntentionAction unused(@NotNull OCSymbol symbol, @NotNull String subject, @NotNull PsiFile file2) {
        if (OCCompilerFeaturesHelper.supportsCxxAttributes(file2) && OCCompilerFeaturesHelper.supportsCxxMaybeUnusedAttribute(file2)) {
            String attribute = OCAttributes.makeCppAttribute("maybe_unused");
            return new OCChangeGCCAttributeIntentionAction(symbol, attribute, attribute, subject, true, OCCompilationContext.create((PsiElement)file2));
        }
        return new OCChangeGCCAttributeIntentionAction(symbol, "unused", "__unused", subject, true, OCCompilationContext.create((PsiElement)file2));
    }

    public static OCChangeGCCAttributeIntentionAction noreturn(@NotNull OCSymbol symbol, @NotNull PsiFile file2) {
        String attribute = OCCompilerFeaturesHelper.supportsCxxAttributes(file2) ? OCAttributes.makeCppAttribute("noreturn") : OCSymbolAttribute.NORETURN.toString();
        return new OCChangeGCCAttributeIntentionAction(symbol, attribute, attribute, true, OCCompilationContext.create((PsiElement)file2));
    }
}

