/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCAddFieldInitializerFix
extends OCPsiElementQuickFix<OCFunctionDefinition> {
    private OCDeclaratorSymbol myField;

    public OCAddFieldInitializerFix(@NotNull OCFunctionDefinition constructor, OCDeclaratorSymbol field) {
        super(constructor);
        this.myField = field;
    }

    @Override
    protected boolean isAvailable(@NotNull OCFunctionDefinition constructor) {
        return OCSearchScope.isInProjectSources(this.myField, constructor.getProject());
    }

    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.add.constructor.initializer.for.field", new Object[0]);
    }

    @Override
    protected String getTextInternal() {
        return "Add constructor initializer for " + this.myField.getNameWithKindLowercase(OCCompilationContext.create(this.myField, this.getProject()));
    }

    @Override
    protected void invoke(PsiFile file2, @NotNull OCFunctionDefinition constructor) {
        OCResolveContext context2 = OCResolveContext.forPsi(constructor);
        OCType type = this.myField.getResolvedType(context2);
        OCConstructorFieldInitializer initializer = OCAddFieldInitializerFix.addFieldInitializer(constructor, this.myField, type.getDefaultValue(context2));
        OCAddInitializerIntentionAction.invokeSmartCompletion(initializer.getArguments().get(0), type);
    }

    public static OCConstructorFieldInitializer addFieldInitializer(OCFunctionDefinition constructor, OCDeclaratorSymbol field, String initializerText) {
        String text = field.getName() + "(" + initializerText + ")";
        OCConstructorFieldInitializer initializer = OCElementFactory.constructorFieldInitializerFromText(text, constructor);
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            initializer = OCChangeUtil.add(existingList, initializer);
        } else {
            OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
            OCChangeUtil.add(list, initializer);
            list = constructor.setConstructorInitializationList(list);
            initializer = list.getInitializers().get(0);
        }
        return initializer;
    }
}

