/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl.symbols;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCLightFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.SLRUSynchronizedCache;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileGlobalSymbolsCache {
    private static final Logger LOG = Logger.getInstance(OCFileGlobalSymbolsCache.class);
    private static final int CACHE_SIZE = 2 * Runtime.getRuntime().availableProcessors();
    private final CachedValue<Cache> myCache;

    public static OCFileGlobalSymbolsCache getInstance(Project project2) {
        return (OCFileGlobalSymbolsCache)project2.getService(OCFileGlobalSymbolsCache.class);
    }

    @NotNull
    public OCFileGlobalSymbols forFile(@NotNull OCFile file2) {
        return (OCFileGlobalSymbols)this.getCache().main.get(file2);
    }

    @NotNull
    public OCNamespaceLikeSymbol lightTableForFile(@NotNull OCFile file2) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = (OCFileGlobalSymbols)cache.main.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        return (OCNamespaceLikeSymbol)cache.lightCache.get(file2);
    }

    @NotNull
    public OCNamespaceLikeSymbol typesOnlyTableForFile(@NotNull OCFile file2) {
        Cache cache = this.getCache();
        OCFileGlobalSymbols symbols = (OCFileGlobalSymbols)cache.main.getIfCached(file2);
        if (symbols != null) {
            return symbols;
        }
        OCLightFileGlobalSymbols lSymbols = (OCLightFileGlobalSymbols)cache.lightCache.getIfCached(file2);
        if (lSymbols != null) {
            return lSymbols;
        }
        return (OCNamespaceLikeSymbol)cache.typesOnlyCache.get(file2);
    }

    @NotNull
    private Cache getCache() {
        return (Cache)this.myCache.getValue();
    }

    public OCFileGlobalSymbolsCache(@NotNull Project project2) {
        this.myCache = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> new CachedValueProvider.Result((Object)new Cache(), new Object[]{FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker()}), false);
    }

    public static void processFile(@NotNull OCFileImpl file2, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        if (!OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap) && !OCFileGlobalSymbolsCache.processFileImpl(file2, symbols, importsMap)) {
            LOG.error("Symbols were collected incorrectly");
        }
    }

    public static boolean processFileImpl(@NotNull OCFileImpl file2, @NotNull Processor<OCSymbol> symbols, @Nullable Map<OCSymbol, VirtualFile> importsMap) {
        FileSymbolTable fileSymbolTable;
        FileSymbolTable fileSymbolTable2;
        if (!FileSymbolTablesCache.areSymbolsLoaded(file2.getProject())) {
            return true;
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file2);
        List<Object> precompiledHeaders = Collections.emptyList();
        OCImmutableInclusionContext precompiledContext = null;
        OCInclusionContext initial = null;
        OCImmutableInclusionContext context2 = OCInclusionContextUtil.headerContext(file2);
        PsiFile importHolder = context2.getRootFile();
        OCResolveConfiguration configuration = context2.getConfiguration();
        if (configuration != null) {
            precompiledContext = OCInclusionContext.initialPCHContextWithoutRoot(configuration, context2.getLanguageKind(), importHolder);
            precompiledHeaders = precompiledContext.getPrecompiledHeaders();
            initial = OCInclusionContext.beforePCHFileContext(configuration, precompiledContext.getLanguageKind(), importHolder);
        }
        if (initial == null) {
            initial = OCInclusionContext.beforePCHFileContext(file2);
        }
        FileSymbolTable.ProcessingState state = new FileSymbolTable.ProcessingState(initial, false);
        boolean contextWasProcessed = false;
        for (VirtualFile virtualFile2 : precompiledHeaders) {
            FileSymbolTable tableForPch = FileSymbolTable.forFile(virtualFile2, initial);
            if (tableForPch == null) continue;
            if (!precompiledContext.isProcessed(virtualFile)) {
                tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, null);
                continue;
            }
            tableForPch.processSymbols(symbols, null, state, importsMap, virtualFile2, virtualFile);
            contextWasProcessed = true;
            break;
        }
        VirtualFile vfImportHolder = OCInclusionContextUtil.getVirtualFile(importHolder);
        if (!contextWasProcessed && OCInclusionContextUtil.isLongLived(vfImportHolder) && !vfImportHolder.equals(virtualFile) && (fileSymbolTable2 = FileSymbolTable.forFile(importHolder, initial)) != null) {
            fileSymbolTable2.processSymbols(symbols, null, state, importsMap, null, virtualFile);
            if (initial.isProcessed(virtualFile)) {
                return false;
            }
        }
        if ((fileSymbolTable = file2.getSymbolTable(initial)) != null) {
            fileSymbolTable.processSymbols(symbols, null, state, importsMap, null, null);
        }
        return true;
    }

    static /* synthetic */ int access$000() {
        return CACHE_SIZE;
    }

    static class Cache {
        private final SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols> main = new SLRUSynchronizedCache<OCFile, OCFileGlobalSymbols>(OCFileGlobalSymbolsCache.access$000(), OCFileGlobalSymbolsCache.access$000()){

            @Override
            @NotNull
            public OCFileGlobalSymbols createValue(OCFile key) {
                return OCFileGlobalSymbols.buildSymbols((OCFileImpl)key);
            }
        };
        private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> lightCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(20, 20){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(OCFile key) {
                return OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, false);
            }
        };
        private final SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols> typesOnlyCache = new SLRUSynchronizedCache<OCFile, OCLightFileGlobalSymbols>(150, 150){

            @Override
            @NotNull
            public OCLightFileGlobalSymbols createValue(OCFile key) {
                return OCLightFileGlobalSymbols.buildSymbols((OCFileImpl)key, true);
            }
        };

        Cache() {
        }
    }
}

