/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.ClangResolveUtils;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.resolve.references.OCReferenceWithContext;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedExpressionImpl
extends OCExpressionWithReferenceBase
implements OCQualifiedExpression,
OCExpectedTypeUtil.Expectable {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl");
    private static final Condition<OCSymbol> CAN_BE_STRUCTURE_FIELD = o -> o.getKind().isExpression();

    public OCQualifiedExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @NotNull
    public OCExpression getQualifier() {
        OCExpression qualifier = (OCExpression)this.findChildByType(OCElementTypes.EXPRESSIONS);
        if (qualifier == null) {
            LOG.error("Qualifier is null in: " + this.getText());
        }
        return qualifier;
    }

    @Override
    @NotNull
    public OCPunctuatorElementType getQualifyingTokenKind() {
        return (OCPunctuatorElementType)this.getQualifyingToken().getElementType();
    }

    @Override
    @NotNull
    public ASTNode getQualifyingToken() {
        OCElement accessor = this.getQualifyingElement();
        for (ASTNode child = accessor.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            return child;
        }
        assert (false);
        return null;
    }

    @Override
    @Nullable
    public OCType getQualifierContainerType(@Nullable Ref<Boolean> outSynthetic) {
        return this.getQualifierContainerType(this.getQualifier().getResolvedType(), null, outSynthetic);
    }

    @Nullable
    private OCType getQualifierContainerType(OCType qualifierType, @Nullable OCPunctuatorElementType forcedQualifyingToken, Ref<Boolean> outSynthetic) {
        if (outSynthetic != null) {
            outSynthetic.set((Object)false);
        }
        if (qualifierType instanceof OCCppReferenceType) {
            qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
        }
        OCResolveContext context2 = OCResolveContext.forPsi(this);
        if (qualifierType instanceof OCStructType && qualifierType.isSubclassOfMagic(context2)) {
            return new OCMagicType();
        }
        OCPunctuatorElementType qualifyingToken = forcedQualifyingToken;
        if (qualifyingToken == null) {
            qualifyingToken = this.getQualifyingTokenKind();
        }
        if (qualifyingToken == OCTokenTypes.DEREF) {
            Set processedTypes = OCTypeUtils.newTypeSet();
            boolean wasDerefOperator = false;
            while (qualifierType instanceof OCStructType && processedTypes.add(qualifierType)) {
                OCStructType structType = (OCStructType)qualifierType;
                OCFunctionSymbol derefOperator = OCOperatorReference.resolveDerefOperator(this, structType);
                if (derefOperator == null) continue;
                wasDerefOperator = true;
                qualifierType = derefOperator.getEffectiveType(this).resolve(context2);
            }
            if (qualifierType instanceof OCPointerType) {
                return ((OCPointerType)qualifierType).getRefType().resolve(this);
            }
            if (wasDerefOperator) {
                return qualifierType;
            }
            if (outSynthetic != null) {
                outSynthetic.set((Object)true);
            }
            return OCUnknownType.INSTANCE;
        }
        return qualifierType;
    }

    @Override
    @NotNull
    public OCElement getQualifyingElement() {
        return (OCElement)this.findChildByType(OCElementTypes.QUALIFIED_EXPRESSION_ACCESSOR);
    }

    @Override
    public boolean canChangeQualifyingToken() {
        return OCElementUtil.getUserVisibleRangeInDocument(this.getQualifyingElement()) != null;
    }

    @Override
    @NotNull
    public List<OCPunctuatorElementType> qualifyingTokensForCompletion() {
        OCType type;
        OCPunctuatorElementType mQTK = this.getQualifyingTokenKind();
        if (this.canChangeQualifyingToken() && (!((type = this.getQualifier().getResolvedType(OCResolveContext.forPsi(this)).getTerminalType()) instanceof OCStructType) || OCOperatorReference.resolveDerefOperator(this, (OCStructType)type) == null)) {
            OCPunctuatorElementType[] items = new OCPunctuatorElementType[]{mQTK, mQTK == OCTokenTypes.DEREF ? OCTokenTypes.DOT : OCTokenTypes.DEREF};
            return Arrays.asList(items);
        }
        return Collections.singletonList(mQTK);
    }

    @NotNull
    public String getName() {
        return OCElementUtil.getIdentifierName(this.getNameIdentifier());
    }

    @Override
    @NotNull
    public String getSymbolName() {
        return OCElementUtil.getIdentifierName(this.findReferenceTokenInCall());
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        OCElementUtil.replaceWithIdentifier(this.getNameIdentifier(), name, this);
        return this;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.findNameStartTokenInCall();
    }

    @Override
    public OCType getExpectedType() {
        OCType expectedType = this.getContext() instanceof OCCallExpression ? OCQualifiedExpressionImpl.getCallExpectedType((OCCallExpression)this.getParent()) : OCExpectedTypeUtil.getExpectedType((OCExpression)this, true);
        if (expectedType == OCUnknownType.INSTANCE) {
            expectedType = OCIdType.pointerToID();
        }
        return expectedType;
    }

    public static OCType getCallExpectedType(@NotNull OCCallExpression callExpr) {
        OCType returnExpectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)callExpr, true);
        ArrayList<OCType> argumentTypes = new ArrayList<OCType>();
        if (returnExpectedType == OCUnknownType.INSTANCE) {
            returnExpectedType = OCVoidType.instance();
        }
        for (OCExpression argument : callExpr.getArguments()) {
            argumentTypes.add(OCExpectedTypeUtil.getExpressionType(argument, true));
        }
        return new OCFunctionType(returnExpectedType, argumentTypes);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public OCSymbolGroupContext getSymbolContext() {
        OCSymbolContext context2;
        OCObjectTypeContext qualifierContext = this.getQualifier().getTypeContext();
        boolean shouldBeFunction = this.getParent() instanceof OCCallExpression && this.getContainingOCFile().isCpp();
        OCPunctuatorElementType qualifyingTokenKind = this.getQualifyingTokenKind();
        if (qualifierContext != null) {
            OCClassSymbol classSymbol = qualifierContext.getType().getClassSymbol();
            if (qualifierContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC) {
                context2 = new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol);
                return new OCSymbolGroupContext(context2);
            }
            if (qualifyingTokenKind == OCTokenTypes.DEREF) {
                context2 = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, classSymbol);
                return new OCSymbolGroupContext(context2);
            }
            if (qualifyingTokenKind != OCTokenTypes.DOT) return null;
            final OCSymbolContext context3 = new OCSymbolContext(this, OCSymbolKind.PROPERTY, classSymbol);
            OCSymbolGroupContext groupContext = new OCSymbolGroupContext(context3){

                @Override
                public String getCannotResolveMessagePrefix(@NotNull Project project2) {
                    return context3.getCannotResolveMessagePrefix(project2);
                }
            };
            groupContext.addSymbolContext(new OCSymbolContext(this, OCSymbolKind.METHOD, classSymbol));
            return groupContext;
        }
        OCType qualifierType = OCTypeUtils.getCppReferencedType(this.getQualifier().getResolvedType());
        if (qualifyingTokenKind == OCTokenTypes.DOT && qualifierType instanceof OCStructType) {
            context2 = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)qualifierType).getSymbol());
            return new OCSymbolGroupContext(context2);
        }
        if (qualifyingTokenKind == OCTokenTypes.DEREF && qualifierType instanceof OCPointerType && ((OCPointerType)qualifierType).getRefType() instanceof OCStructType) {
            context2 = new OCSymbolContext(this, shouldBeFunction ? OCSymbolKind.FUNCTION_DECLARATION : OCSymbolKind.STRUCT_FIELD, ((OCStructType)((OCPointerType)qualifierType).getRefType()).getSymbol());
            return new OCSymbolGroupContext(context2);
        }
        if (!(qualifierType instanceof OCObjectType)) return null;
        context2 = new OCSymbolContext(this, OCSymbolKind.INSTANCE_VARIABLE, ((OCObjectType)qualifierType).getClassSymbol());
        return new OCSymbolGroupContext(context2);
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitQualifiedExpression(this);
    }

    @Nullable
    public PsiElement resolve() {
        OCSymbol symbol = this.resolveToSymbol();
        return symbol != null ? symbol.locateDefinition(this.getProject()) : null;
    }

    @Override
    public boolean processTargets(String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched, @Nullable OCPunctuatorElementType forcedQualifyingToken, boolean filterOverloads, boolean ignoreImports, @Nullable Ref<OCType> outQualifierType, @NotNull OCResolveContext resolveContext) {
        if (resolveContext.isProcessNonImported() != ignoreImports) {
            resolveContext = resolveContext.clone();
            resolveContext.setProcessNonImported(ignoreImports);
        }
        Object qualifierContext = this.getContainerTypeContext(forcedQualifyingToken, resolveContext);
        if (outQualifierType != null && qualifierContext instanceof QualifierTypeContext) {
            outQualifierType.set((Object)((QualifierTypeContext)qualifierContext).containerType);
        }
        return this.doProcessTargets(qualifierContext, symbolName, processor2, processStaticMismatched, filterOverloads, false, false, resolveContext, true);
    }

    private boolean doProcessTargets(@Nullable Object qualifierContext, String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible, @NotNull OCResolveContext context2, boolean resolveSpecializations) {
        if (qualifierContext instanceof OCObjectTypeContext) {
            return this.processObjCMembers((OCObjectTypeContext)qualifierContext, symbolName, processor2, processStaticMismatched);
        }
        if (qualifierContext instanceof QualifierTypeContext) {
            OCType containerType = ((QualifierTypeContext)qualifierContext).containerType;
            if (containerType instanceof OCStructType && ((OCStructType)containerType).getKind() != OCSymbolKind.ENUM) {
                return this.processStructMembers(symbolName, processor2, filterOverloads, context2, (QualifierTypeContext)qualifierContext, acceptOnlyCompatible, filterAmbigs, resolveSpecializations);
            }
            if (containerType.isUnknown() || containerType instanceof OCMagicType) {
                processor2.process((Object)new OCDeclaratorSymbolImpl(symbolName, new OCMagicType(symbolName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER));
            }
        }
        return true;
    }

    private boolean processObjCMembers(OCObjectTypeContext qualifierContext, String symbolName, Processor<OCSymbol> processor2, boolean processStaticMismatched) {
        ReadWriteAccessDetector.Access access;
        OCObjectTypeContext objectTypeContext = qualifierContext;
        boolean isStaticContext = objectTypeContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC;
        boolean isDotAccess = this.getQualifyingTokenKind() == OCTokenTypes.DOT;
        Processor membersProcessor = symbol -> {
            if (!OCCompilerFeaturesHelper.supportsLaterMethodDeclaration() && !OCResolveUtil.isEarlierInCode((OCSymbol)symbol, this) || OCResolveUtil.isDisabledSymbol(symbol, this.getContainingOCFile())) {
                return true;
            }
            if (isDotAccess && symbol instanceof OCMethodSymbol) {
                return processor2.process(symbol);
            }
            if (isDotAccess && symbol instanceof OCPropertySymbol) {
                return processor2.process(symbol);
            }
            if (!isDotAccess && symbol instanceof OCInstanceVariableSymbol && !isStaticContext) {
                return processor2.process(symbol);
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(membersProcessor, symbol -> symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isReadonly() && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCInstanceVariableSymbol && ((OCInstanceVariableSymbol)symbol).getGeneratedFromProperty() == null || symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCSetter(symbol.getName()) && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCPropertySymbol && objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), symbol -> symbol instanceof OCInstanceVariableSymbol || objectTypeContext.getStaticMode().fitsStaticness((OCMemberSymbol)symbol), processStaticMismatched ? Conditions.alwaysTrue() : Conditions.alwaysFalse());
        objectTypeContext.getType().processMembers(symbolName, OCMemberSymbol.class, orderedProcessor);
        if (symbolName != null && isDotAccess && ((access = new OCReadWriteAccessDetector().getExpressionAccess(this)) == ReadWriteAccessDetector.Access.Write || access == ReadWriteAccessDetector.Access.ReadWrite && !objectTypeContext.getType().processMembers(symbolName, OCMethodSymbol.class, symbol -> symbol.isStatic()))) {
            objectTypeContext.getType().processMembers(OCQualifiedExpressionImpl.getSetterName(symbolName), OCMethodSymbol.class, orderedProcessor);
        }
        return orderedProcessor.finish();
    }

    @Override
    @NotNull
    public CVQualifiers getCVQualifiers() {
        return this.getCVQualifiers(this.getQualifier().getResolvedType());
    }

    @NotNull
    public CVQualifiers getCVQualifiers(@NotNull OCType qualifierType) {
        CVQualifiers typeAndOuterFunctionQualifiers = OCCodeInsightUtil.getCVQualifiers(this.getQualifier(), qualifierType);
        if (this.getQualifyingTokenKind() == OCTokenTypes.DEREF) {
            if (qualifierType instanceof OCCppReferenceType) {
                qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
            }
            if (qualifierType instanceof OCStructType && OCOperatorReference.resolveDerefOperator(this, (OCStructType)qualifierType) != null) {
                return CVQualifiers.EMPTY;
            }
        }
        return typeAndOuterFunctionQualifiers;
    }

    @Nullable
    private OCExprValueCategory getQualifierValueCategory() {
        Object reference = this.getReference();
        try {
            ClangResolveUtils.prohibitClangResolve();
            OCExprValueCategory oCExprValueCategory = reference != null ? (OCExprValueCategory)((Object)ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching(reference, (ResolveCache.AbstractResolver)new ExprValueCategoryResolver(), false, false)) : null;
            return oCExprValueCategory;
        }
        finally {
            ClangResolveUtils.allowClangResolve();
        }
    }

    private boolean processStructMembers(String name, Processor<OCSymbol> processor2, boolean filterOverloads, OCResolveContext context2, QualifierTypeContext qualifierContext, boolean acceptOnlyCompatible, boolean filterAmbigs, boolean resolveSpecializations) {
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(this);
        List<OCSymbol> filtered = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)qualifierContext.containerType, name, typeArguments, context2, resolveSpecializations);
        if (name == null) {
            return ContainerUtil.process(filtered, processor2);
        }
        if (filterOverloads && OCParenthesesUtils.topmostParenthesized(this).getParent() instanceof OCCallExpression) {
            OCType containerType = qualifierContext.containerType;
            CVQualifiers cvQualifiers = this.getCVQualifiers(qualifierContext.qualifierType);
            containerType = containerType.cloneWithAddedCVQualifiers(cvQualifiers, this.getProject());
            OCCallExpression parent = (OCCallExpression)OCParenthesesUtils.topmostParenthesized(this).getParent();
            OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(parent.getArguments(), context2);
            boolean hasMagic = ((OCStructType)qualifierContext.containerType).getStructs().size() > 1;
            OCSymbol result2 = OCResolveOverloadsUtil.resolveOverloads(filtered, arguments, containerType, this.getQualifierValueCategory(), null, acceptOnlyCompatible, filterAmbigs, true, hasMagic, false, false, context2, this);
            if (result2 != null) {
                return processor2.process((Object)result2);
            }
        } else {
            return ContainerUtil.process(filtered, processor2);
        }
        return true;
    }

    public static List<OCSymbol> getResolvedMembers(OCStructType qualifierType, String memberName, List<OCTypeArgument> typeArguments, OCResolveContext context2, boolean resolveSpecializations) {
        ArrayList<OCTemplateSymbol> resolved;
        List<OCCompilerGeneratedConstructorSymbol> filtered;
        OCSymbolReference.UsingAndTypedefSymbolsResolver usingsProcessor = new OCSymbolReference.UsingAndTypedefSymbolsResolver(false, true, false, resolveSpecializations, null, null, context2);
        qualifierType.processMembers(memberName, usingsProcessor, context2);
        if (OCResolveUtil.isDestructorName(memberName)) {
            filtered = usingsProcessor.getAnswer();
            if (filtered.isEmpty() && memberName.substring(1).equals(qualifierType.getName())) {
                filtered = Collections.singletonList(new OCCompilerGeneratedConstructorSymbol(qualifierType.getSymbol(), OCCompilerGeneratedConstructorSymbol.Kind.DefaultDtor, context2.getProject()));
            }
        } else {
            filtered = ContainerUtil.filter(usingsProcessor.getAnswer(), CAN_BE_STRUCTURE_FIELD);
        }
        if (resolveSpecializations && typeArguments != null && !(resolved = new ArrayList<OCTemplateSymbol>(OCSimpleTypeSubstitution.resolveTemplateSpecialization(ContainerUtil.findAll((Collection)filtered, OCTemplateSymbol.class), typeArguments, context2))).isEmpty()) {
            filtered = resolved;
        }
        return filtered;
    }

    @Nullable
    private Object getContainerTypeContext(@Nullable OCPunctuatorElementType forcedQualifyingToken, @NotNull OCResolveContext context2) {
        OCExpression qualifier = OCParenthesesUtils.diveIntoParentheses(this.getQualifier());
        if (qualifier == null) {
            return null;
        }
        OCType qualifierType = qualifier.getResolvedType(context2);
        if (qualifier instanceof OCSendMessageExpression && OCTypeGuesser.isOfficialNamingConvention(((OCSendMessageExpression)qualifier).getMessageSelector())) {
            qualifierType = qualifierType.getGuessedType();
        }
        if (qualifier instanceof OCQualifiedExpression && OCTypeGuesser.isOfficialNamingConvention(((OCQualifiedExpression)qualifier).getName())) {
            qualifierType = qualifierType.getGuessedType();
        }
        boolean treatIDAsNSObject = forcedQualifyingToken == OCTokenTypes.DEREF;
        OCObjectTypeContext typeContext = qualifier.getTypeContext(qualifier, qualifierType, treatIDAsNSObject, context2.isProcessNonImported());
        return typeContext != null ? typeContext : new QualifierTypeContext(qualifierType, this.getQualifierContainerType(qualifierType, forcedQualifyingToken, null));
    }

    private static String getSetterName(String getterName) {
        return "set" + StringUtil.capitalize((String)getterName) + ":";
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol() {
        return this.resolveToSymbol(OCResolveContext.forPsi(this), true, false, false);
    }

    @Override
    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context2, boolean filterOverloads, boolean filterAmbigs, boolean acceptOnlyCompatible) {
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        this.doProcessTargets(this.getContainerTypeContext(null, context2), this.getSymbolName(), (Processor<OCSymbol>)collector, true, filterOverloads, filterAmbigs, acceptOnlyCompatible, context2, true);
        return (OCSymbol)collector.getFoundValue();
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveToOverloadsSymbols() {
        return this.resolveToOverloadsSymbols(true);
    }

    @Override
    @NotNull
    public Collection<OCSymbol> resolveTemplateDeclarations() {
        return this.resolveToOverloadsSymbols(false);
    }

    @NotNull
    private Collection<OCSymbol> resolveToOverloadsSymbols(boolean resolveSpecializations) {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        OCResolveContext resolveContext = OCResolveContext.forPsi(this);
        Object qualifierContext = this.getContainerTypeContext(null, resolveContext);
        this.doProcessTargets(qualifierContext, this.getSymbolName(), (Processor<OCSymbol>)collector, true, false, false, false, resolveContext, resolveSpecializations);
        return collector.getResults();
    }

    @Nullable
    protected PsiReference createReference() {
        return new OCReferenceWithContext(){

            @NotNull
            @Contract(pure=true)
            public PsiElement getElement() {
                return OCQualifiedExpressionImpl.this;
            }

            @NotNull
            public TextRange getRangeInElement() {
                return OCQualifiedExpressionImpl.this.getRangeInCallElement();
            }

            public PsiElement resolve() {
                return ClangResolveUtils.findCombined(this, ref -> {
                    OCSymbol clangSymbol = ClangResolveUtils.findTargetSymbolViaClang(ref);
                    if (clangSymbol != null) {
                        PsiElement clangElement = clangSymbol.locateDefinition(OCQualifiedExpressionImpl.this.getProject());
                        ClangResolveUtils.assertClangResolvesSameElement(clangElement, () -> OCQualifiedExpressionImpl.this.resolve());
                        return clangElement;
                    }
                    return null;
                }, ref -> OCQualifiedExpressionImpl.this.resolve());
            }

            @NotNull
            public String getCanonicalText() {
                return OCQualifiedExpressionImpl.this.getSymbolName();
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                return OCQualifiedExpressionImpl.this.setName(newElementName);
            }

            @Override
            public PsiElement bindToSymbol(@NotNull OCSymbol symbol) {
                String newName = symbol.getName();
                String getterFromSetter = OCNameSuggester.getObjCGetterFromSetter(newName);
                if (getterFromSetter != null) {
                    this.handleElementRename(getterFromSetter);
                } else {
                    this.handleElementRename(newName);
                }
                return this.getElement();
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                return symbol != null ? this.bindToSymbol((OCSymbol)symbol) : element;
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (!(element instanceof OCSymbolDeclarator)) {
                    return false;
                }
                Object symbol = ((OCSymbolDeclarator)element).getSymbol();
                OCSymbol thisSymbol = ClangResolveUtils.findCombined(this, ref -> ClangResolveUtils.findTargetSymbolViaClang(ref), ref -> this.resolveToSymbol());
                if (Comparing.equal((Object)thisSymbol, symbol)) {
                    return true;
                }
                if (symbol instanceof OCMethodSymbol && thisSymbol instanceof OCPropertySymbol) {
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(OCQualifiedExpressionImpl.this);
                    if (access == ReadWriteAccessDetector.Access.Read && OCNameSuggester.isObjCSetter(symbol.getName())) {
                        return false;
                    }
                    if (access == ReadWriteAccessDetector.Access.Write && OCNameSuggester.isObjCGetter(symbol.getName())) {
                        return false;
                    }
                    if ((symbol = symbol.getAssociatedSymbol(OCQualifiedExpressionImpl.this.getProject())) != null) {
                        symbol = ((OCMethodSymbol)symbol).getGeneratedFromProperty();
                    }
                    return Comparing.equal((Object)thisSymbol, symbol);
                }
                if (symbol instanceof OCPropertySymbol && thisSymbol instanceof OCMethodSymbol) {
                    if (symbol.equals(((OCMethodSymbol)thisSymbol).getGeneratedFromProperty())) {
                        return true;
                    }
                    return (thisSymbol = thisSymbol.getAssociatedSymbol(OCQualifiedExpressionImpl.this.getProject())) != null && Comparing.equal((Object)((OCMethodSymbol)thisSymbol).getGeneratedFromProperty(), symbol);
                }
                if (thisSymbol instanceof OCFunctionGroupSymbol) {
                    Object finalSymbol = symbol;
                    return ((OCFunctionGroupSymbol)thisSymbol).getOverloads().stream().anyMatch(f -> f.isSameSymbol((OCSymbol)finalSymbol, OCQualifiedExpressionImpl.this.getProject()));
                }
                if (thisSymbol != null && thisSymbol.getKind().isTemplateParameter() && symbol != null && !symbol.getKind().isTemplateParameter()) {
                    return true;
                }
                return thisSymbol != null && thisSymbol.isSameSymbol((OCSymbol)symbol, OCQualifiedExpressionImpl.this.getProject());
            }

            public boolean isSoft() {
                return false;
            }

            @Override
            public OCSymbol resolveToSymbol() {
                return OCQualifiedExpressionImpl.this.resolveToSymbol();
            }

            @Nullable
            public OCSymbol resolveToSymbol(@NotNull OCResolveContext context2) {
                return OCQualifiedExpressionImpl.this.resolveToSymbol(context2, true, false, false);
            }
        };
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context2) {
        Object qualifierContext = this.getContainerTypeContext(null, context2);
        CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>((Processor<OCSymbol>)collector, (Condition<T>[])new Condition[]{symbol -> symbol instanceof OCMethodSymbol && OCNameSuggester.isObjCGetter(symbol.getName()) && qualifierContext instanceof OCObjectTypeContext && ((OCObjectTypeContext)qualifierContext).getStaticMode() == OCObjectTypeContext.StaticMode.STATIC == ((OCMethodSymbol)symbol).isStatic(), OCSymbol.NON_FANTOM_SYMBOL_CONDITION, Conditions.alwaysTrue()});
        this.doProcessTargets(qualifierContext, this.getSymbolName(), orderedProcessor, true, true, false, false, context2, true);
        orderedProcessor.finish();
        OCSymbol symbol2 = (OCSymbol)collector.getFoundValue();
        if (symbol2 != null) {
            if (symbol2 instanceof OCMethodSymbol) {
                OCMethodSymbol methodSymbol = (OCMethodSymbol)symbol2;
                if (OCNameSuggester.isObjCGetter(symbol2.getName())) {
                    OCType type;
                    if (qualifierContext instanceof OCObjectTypeContext) {
                        OCObjectTypeContext objectTypeContext = (OCObjectTypeContext)qualifierContext;
                        type = methodSymbol.getEffectiveType(objectTypeContext.getType(), this).resolve(context2);
                        OCType guessedType = OCTypeGuesser.getMethodGuessedReturnType(methodSymbol, objectTypeContext, null, this);
                        if (guessedType != null) {
                            return type.cloneWithGuessedType(guessedType);
                        }
                    } else {
                        type = methodSymbol.getEffectiveType(this).resolve(context2);
                    }
                    return type;
                }
                if (OCNameSuggester.isObjCSetter(symbol2.getName())) {
                    List<OCMethodSymbol.SelectorPartSymbol> selectors = methodSymbol.getSelectors();
                    OCDeclaratorSymbol parameter = selectors.size() == 1 ? selectors.get(0).getParameter() : null;
                    return parameter != null ? parameter.getType() : OCUnknownType.INSTANCE;
                }
                return OCVoidType.instance();
            }
            return OCTypeUtils.getSymbolType(symbol2, OCSymbolReference.getLocalReference(this.getName(), (PsiElement)this), context2);
        }
        if (qualifierContext instanceof QualifierTypeContext && ((QualifierTypeContext)qualifierContext).qualifierType instanceof OCMagicType || qualifierContext instanceof OCObjectTypeContext && ((OCObjectTypeContext)qualifierContext).getOriginalType() instanceof OCMagicType) {
            return new OCMagicType(this.getSymbolName());
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    public OCTypeArgumentList getTemplateArgumentList() {
        return (OCTypeArgumentList)this.findChildByType(OCElementTypes.TEMPLATE_ARGUMENT_LIST);
    }

    private static class QualifierTypeContext {
        OCType qualifierType;
        OCType containerType;

        QualifierTypeContext(OCType qualifierType, OCType containerType) {
            this.qualifierType = qualifierType;
            this.containerType = containerType;
        }
    }

    private static class ExprValueCategoryResolver
    implements ResolveCache.AbstractResolver<PsiReference, OCExprValueCategory> {
        private ExprValueCategoryResolver() {
        }

        public OCExprValueCategory resolve(@NotNull PsiReference reference, boolean incompleteCode) {
            return OCExprValueCategory.classify(((OCQualifiedExpression)reference.getElement()).getQualifier());
        }
    }
}

