/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLazyElementBase
extends LazyParseablePsiElement
implements OCElement {
    public OCLazyElementBase(@NotNull IElementType type, CharSequence buffer) {
        super(type, buffer);
    }

    @NotNull
    public Language getLanguage() {
        return OCLanguageUtils.getSlowLanguage();
    }

    public String toString() {
        return OCElementUtil.getElementDebugName(this);
    }

    @Override
    public OCFile getContainingOCFile() {
        return (OCFile)super.getContainingFile();
    }

    protected Icon getBaseIcon() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.getBaseIcon() : super.getBaseIcon();
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.computeFullIconNow(this, this.getProject()) : super.getElementIcon(flags);
    }

    public ItemPresentation getPresentation() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? new OCSymbolPresentation(symbol, this.getProject()) : super.getPresentation();
    }

    @Nullable
    private OCSymbol getElementSymbolIfAny() {
        return this instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)((Object)this)).getSymbol() : null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof OCVisitor) {
            this.accept((OCVisitor)visitor);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitOCElement(this);
    }

    @Override
    public String getTextWithMacros() {
        return OCElementUtil.getTextWithMacros(this);
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        return OCElementUtil.getRangeWithMacros(this);
    }

    @Override
    public boolean isEmpty() {
        return OCElementUtil.isElementEmpty(this);
    }

    public PsiReference findReferenceAt(int offset) {
        PsiReference refInMacro = OCElementUtil.findReferenceInMacro(this.findElementAt(offset));
        return refInMacro != null ? refInMacro : super.findReferenceAt(offset);
    }

    @NotNull
    public SearchScope getUseScope() {
        return OCScopeInfo.createScopeInfo(this).getSearchScope();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        OCChangeUtil.delete(child.getPsi());
    }

    @Override
    public long getComplexOffset() {
        return OCSymbolOffsetUtil.getComplexOffset(this);
    }

    public TreeElement getFirstChildNode() {
        if (this.isParsed()) {
            return super.getFirstChildNode();
        }
        return (TreeElement)OCParser.computeSyncWithEDTPriority(this.getContainingFile(), () -> super.getFirstChildNode());
    }

    public TreeElement getLastChildNode() {
        if (this.isParsed()) {
            return super.getLastChildNode();
        }
        return (TreeElement)OCParser.computeSyncWithEDTPriority(this.getContainingFile(), () -> super.getLastChildNode());
    }
}

