/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCParser;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCReparseablePsiElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLazyBlockStatementElementType
extends OCReparseablePsiElementType {
    @Nullable
    private static LazyParsingCallback ourGlobalLazyParsingCallback = null;

    public OCLazyBlockStatementElementType() {
        super("LAZY_BLOCK", (type, buffer) -> new OCLazyBlockStatementImpl((IElementType)type, (CharSequence)buffer));
    }

    public static void setGlobalLazyParsingCallback(@Nullable LazyParsingCallback callback) {
        ourGlobalLazyParsingCallback = callback;
    }

    public boolean isParsable(@Nullable ASTNode parent, @NotNull CharSequence buffer, @NotNull Language fileLanguage, @NotNull Project project2) {
        PsiFile file2;
        PsiFile psiFile = file2 = parent != null ? parent.getPsi().getContainingFile() : null;
        if (file2 == null || OCParser.isSimplifiedParsingMode(file2).booleanValue()) {
            return false;
        }
        int offset = parent.getPsi().getTextRange().getStartOffset();
        OCFile ocFile = (OCFile)file2;
        return (Boolean)OCParser.computeSyncWithEDTPriority(file2, () -> {
            OCImmutableInclusionContext baseContext = OCParser.evaluatePartialContext(ocFile, offset);
            OCInclusionContext currentFileContext = baseContext.derive();
            currentFileContext = OCParser.updatePartialContext(parent.getPsi(), currentFileContext);
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, OCInclusionContextUtil.getVirtualFile(ocFile));
            lexer.start(buffer);
            return OCLazyBlockStatementElementType.isSafeBlock(() -> {
                IElementType token = lexer.getTokenType();
                if (token != null) {
                    lexer.advance();
                }
                return token;
            }, OCTokenTypes.LBRACE, OCTokenTypes.RBRACE) && lexer.getTokenType() == null;
        });
    }

    @Override
    public ASTNode doParse(ASTNode chameleon, PsiBuilder builder2) {
        OCParsing parsing = new OCParsing(builder2, chameleon.getElementType());
        PsiElement parent = chameleon.getPsi().getContext();
        if (parent instanceof DummyHolder) {
            PsiElement context2 = parent.getContext();
            PsiElement psiElement = parent = context2 != null ? context2.getContext() : null;
        }
        if (ourGlobalLazyParsingCallback != null) {
            ourGlobalLazyParsingCallback.onParsingLazyBlock(chameleon, builder2, parsing);
        }
        parsing.parseCompoundStatement(parent instanceof OCMethod, false);
        return parsing.getTreeBuilt();
    }

    public static boolean isSafeBlock(@NotNull Supplier<? extends IElementType> tokenizer, @NotNull IElementType openToken, @NotNull IElementType closeToken) {
        IElementType token = tokenizer.get();
        if (token != openToken || token instanceof ForeignLeafType) {
            return false;
        }
        int blockScopeLevel = 1;
        int ifdefScopeLevel = 0;
        boolean isSafe = true;
        while (blockScopeLevel > 0) {
            IElementType originalToken = tokenizer.get();
            token = OCElementUtil.getUnwrappedTokeType(originalToken);
            if (OCTokenTypes.BLOCK_UNSAFE_DIRECTIVES.contains(token)) {
                isSafe = false;
            }
            if (token == openToken) {
                ++blockScopeLevel;
            } else if (token == closeToken) {
                if (--blockScopeLevel == 0 && originalToken instanceof ForeignLeafType) {
                    isSafe = false;
                }
            } else if (OCTokenTypes.IF_DIRECTIVES.contains(token)) {
                ++ifdefScopeLevel;
            } else if (token == OCTokenTypes.ENDIF_DIRECTIVE && --ifdefScopeLevel < 0) {
                isSafe = false;
            }
            if (OCTokenTypes.DIRECTIVES.contains(token)) {
                while ((token = OCElementUtil.getUnwrappedTokeType(tokenizer.get())) != OCTokenTypes.END_OF_DIRECTIVE_CONTENT && token != null) {
                }
            }
            if (token != null) continue;
            isSafe = false;
            break;
        }
        return isSafe && ifdefScopeLevel == 0;
    }

    public static interface LazyParsingCallback {
        public void onParsingLazyBlock(ASTNode var1, PsiBuilder var2, OCParsing var3);
    }
}

