/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.generation.actions.PresentableCodeInsightActionHandler;
import com.intellij.icons.AllIcons;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.navigation.OCGotoActionSync;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGotoSuperHandler
implements PresentableCodeInsightActionHandler,
LanguageCodeInsightActionHandler {
    public void update(@NotNull Editor editor, @NotNull PsiFile file2, Presentation presentation) {
        presentation.setText("S_uper Definition");
        presentation.setDescription("");
    }

    public boolean isValidFor(Editor editor, PsiFile file2) {
        return file2 instanceof OCFile;
    }

    @Nullable
    public static OCGotoAction<PsiElement> getAction(PsiElement element) {
        Collection<? extends OCSymbol> supers = OCGotoSuperHandler.getSuperSymbols(element);
        if (ContainerUtil.isEmpty(supers)) {
            return null;
        }
        return new OCGotoSuperSymbolActionSync(element, OCGotoSuperHandler.inferName(supers, element.getProject()), OCGotoSuperHandler.inferIcon(supers));
    }

    @NotNull
    private static Icon inferIcon(@NotNull Collection<? extends OCSymbol> supers) {
        return OCGotoSuperHandler.isImplementor(supers) ? AllIcons.Gutter.ImplementingMethod : AllIcons.Gutter.OverridingMethod;
    }

    @NotNull
    private static String inferName(@NotNull Collection<? extends OCSymbol> supers, @NotNull Project project2) {
        OCSymbol superSymbol;
        StringBuilder buffer = new StringBuilder("Go to ");
        OCSymbol oCSymbol = superSymbol = supers.isEmpty() ? null : supers.iterator().next();
        if (superSymbol instanceof OCMemberSymbol) {
            buffer.append("super ").append(superSymbol.getKind().getNameLowercase()).append(" in ").append(((OCMemberSymbol)superSymbol).getParent().getNameWithKindLowercase(OCCompilationContext.create(superSymbol, project2)));
        } else if (superSymbol instanceof OCFunctionSymbol) {
            OCSymbolWithQualifiedName parent = ((OCFunctionSymbol)superSymbol).getParent();
            if (parent != null) {
                buffer.append("base function in ").append(parent.getNameWithKindLowercase(OCCompilationContext.create(superSymbol, project2)));
            }
        } else {
            buffer.append("super type");
        }
        return buffer.toString();
    }

    private static boolean isImplementor(@NotNull Collection<? extends OCSymbol> supers) {
        for (OCSymbol oCSymbol : supers) {
            boolean isCurImplementor;
            if (oCSymbol instanceof OCProtocolSymbol) {
                isCurImplementor = true;
            } else if (oCSymbol instanceof OCMethodSymbol) {
                isCurImplementor = ((OCMethodSymbol)oCSymbol).getParent() instanceof OCProtocolSymbol;
            } else {
                boolean bl = isCurImplementor = oCSymbol instanceof OCFunctionSymbol && oCSymbol.isPredeclaration();
            }
            if (isCurImplementor) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static Collection<? extends OCSymbol> getSuperSymbols(PsiElement element) {
        OCStructSymbol structSymbol;
        if (element instanceof OCClassDeclaration && !(element instanceof OCClassPredeclaration)) {
            return ((OCClassDeclaration)element).getSuperSymbols();
        }
        if (element instanceof OCDeclarator || element instanceof OCMethod) {
            Object symbol2 = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol2 instanceof OCFunctionSymbol && ((OCDeclarator)element).getParameterList() != null && ((OCDeclarator)element).isPossibleStructMember()) {
                return new OCFunctionAncestorsQuery((OCFunctionSymbol)symbol2, false, false, project2).findAll();
            }
            if (symbol2 instanceof OCMemberSymbol) {
                CommonProcessors.CollectUniquesProcessor processor2 = new CommonProcessors.CollectUniquesProcessor();
                OCMemberInheritorsSearch.SearchParameters<OCMemberSymbol> parameters = OCMemberInheritorsSearch.getParameters((OCMemberSymbol)symbol2, project2);
                parameters.setIncludeSelfImplementation(false);
                parameters.setInheritors(false);
                parameters.setAncestors(true);
                if (((OCMemberSymbol)symbol2).getParent() instanceof OCImplementationSymbol) {
                    parameters.setImplementationsThenInterfaces(true);
                } else {
                    parameters.setInterfacesThenImplementations(true);
                }
                OCMemberInheritorsSearch.search(parameters).forEach((Processor)processor2);
                return processor2.getResults();
            }
        } else if (element instanceof OCStruct && (structSymbol = (OCStructSymbol)((OCStruct)element).getSymbol()) != null) {
            ArrayList supers = new ArrayList();
            structSymbol.processBaseClasses(OCResolveContext.forPsi(element), (symbol, visibility) -> {
                supers.add(symbol);
                return true;
            });
            return supers;
        }
        return null;
    }

    @Nullable
    public static PsiElement getContext(@Nullable PsiElement element) {
        PsiElement context2 = PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCFunctionDeclaration.class, OCMethod.class, OCClassDeclaration.class, OCStruct.class});
        if (context2 instanceof OCFunctionDeclaration) {
            context2 = ((OCFunctionDeclaration)context2).getDeclarator();
        }
        return context2;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        PsiElement context2 = OCGotoSuperHandler.getContext(element);
        OCGotoAction<PsiElement> action = OCGotoSuperHandler.getAction(context2);
        if (action != null) {
            action.navigate(null, editor);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class OCGotoSuperSymbolActionSync
    extends OCGotoActionSync<PsiElement> {
        OCGotoSuperSymbolActionSync(@NotNull PsiElement element, @NotNull String name, @NotNull Icon icon) {
            super(element, name, icon);
        }

        @Override
        @NotNull
        protected Collection<? extends OCSymbol> evaluateTargets(@NotNull PsiElement source) {
            Collection superSymbols = OCGotoSuperHandler.getSuperSymbols(source);
            if (superSymbols == null) {
                return Collections.emptyList();
            }
            this.setIcon(OCGotoSuperHandler.inferIcon(superSymbols));
            this.setName(OCGotoSuperHandler.inferName(superSymbols, source.getProject()));
            return superSymbols;
        }
    }
}

