/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.GotoClassContributor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCForeignSymbol;
import com.jetbrains.cidr.lang.symbols.OCNonNavigatableSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoByNameContributor
implements GotoClassContributor,
ChooseByNameContributorEx {
    public void processNames(@NotNull Processor<? super String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        Project project2 = Objects.requireNonNull(scope.getProject());
        if (!ContainerUtil.process(OCGlobalProjectSymbolsCache.getAllSymbolNames(project2), processor2)) {
            return;
        }
        OCGlobalProjectSymbolsCache.getAllCategories(project2).processAllValues(o -> o instanceof OCNonNavigatableSymbol || processor2.process((Object)(o.getName() + "+" + o.getCategoryName())));
    }

    public void processElementsWithName(@NotNull String name, @NotNull Processor<? super NavigationItem> processor2, @NotNull FindSymbolParameters parameters) {
        GlobalSearchScope scope0 = parameters.getSearchScope();
        GlobalSearchScope scope = scope0.isSearchInLibraries() ? scope0 : scope0.intersectWith(OCSearchScope.getProjectSourcesScope(parameters.getProject()));
        this.processSymbolsByName(name, processor2, parameters.getProject(), scope, (Condition<OCSymbol>)((Condition)symbol -> symbol instanceof OCImplementationSymbol), false);
    }

    protected abstract boolean filterSymbol(@NotNull Project var1, @NotNull OCSymbol var2);

    public void processSymbolsByName(@NotNull String name, @NotNull Processor<? super OCSymbolNavigationItem> processor2, @NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull Condition<OCSymbol> condition, boolean isStrict) {
        HashSet implementations = new HashSet();
        Processor innerProcessor = ocSymbol -> {
            if (ocSymbol instanceof OCUsingSymbol) {
                return true;
            }
            if (ocSymbol.getKind().isType() && ocSymbol.isPredeclaration()) {
                return true;
            }
            if (ocSymbol instanceof OCForeignSymbol) {
                return true;
            }
            if (ocSymbol.isSynthetic()) {
                return true;
            }
            if (ocSymbol instanceof OCInterfaceSymbol && implementations.contains(ocSymbol.getPresentableName())) {
                return true;
            }
            VirtualFile file2 = ocSymbol.getContainingFile();
            if (file2 != null && this.filterSymbol(project2, (OCSymbol)ocSymbol) && scope.contains(file2)) {
                if (!processor2.process((Object)new OCSymbolNavigationItem((OCSymbol)ocSymbol, project2))) {
                    return false;
                }
                if (ocSymbol instanceof OCImplementationSymbol) {
                    implementations.add(ocSymbol.getPresentableName());
                }
            }
            return true;
        };
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(innerProcessor, condition, isStrict ? Conditions.alwaysFalse() : Conditions.alwaysTrue());
        int plus = name.indexOf(43);
        if (plus != -1) {
            String className = name.substring(0, plus).trim();
            String categoryName = name.substring(plus + 1).trim();
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, (Processor<? super OCSymbol>)Processors.filter(orderedProcessor, o -> o instanceof OCClassSymbol && o.getName().equals(className)), categoryName);
        } else {
            OCGlobalProjectSymbolsCache.processByQualifiedName(project2, orderedProcessor, name);
            OCGlobalProjectSymbolsCache.processSymbolsByCategory(project2, orderedProcessor, name);
        }
        orderedProcessor.finish();
    }

    @Nullable
    public String getQualifiedName(NavigationItem item) {
        OCSymbol symbol = null;
        Project project2 = null;
        if (item instanceof OCSymbolHolderVirtualPsiElement) {
            symbol = (OCSymbol)((OCSymbolHolderVirtualPsiElement)item).getSymbol();
            project2 = ((OCSymbolHolderVirtualPsiElement)item).getProject();
        } else if (item instanceof OCSymbolNavigationItem) {
            symbol = ((OCSymbolNavigationItem)item).getSymbol();
            project2 = ((OCSymbolNavigationItem)item).getProject();
        }
        if (symbol instanceof OCSymbolWithQualifiedName) {
            OCResolveContext context2;
            OCQualifiedName qualifiedName;
            OCSymbolWithQualifiedName qnSymbol = (OCSymbolWithQualifiedName)symbol;
            if (qnSymbol.getQualifier() == null && (qualifiedName = qnSymbol.getResolvedQualifiedName(context2 = OCResolveContext.forSymbol(qnSymbol, project2))) != null) {
                return qualifiedName.getFullName(context2);
            }
        } else if (symbol != null) {
            return symbol.getPresentableName();
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameSeparator() {
        return "::";
    }
}

