/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGotoAction<Psi extends PsiElement> {
    protected static final Logger LOG = Logger.getInstance((String)OCGotoAction.class.getName());
    @NotNull
    private final SmartPsiElementPointer<Psi> mySource;
    @NotNull
    private String myName;
    @NotNull
    private Icon myIcon;

    public OCGotoAction(@NotNull Psi source, @NotNull String name, @NotNull Icon icon) {
        this.mySource = SmartPointerManager.getInstance((Project)source.getProject()).createSmartPsiElementPointer(source);
        this.myName = name;
        this.myIcon = icon;
    }

    @NotNull
    public Icon getIcon() {
        return this.myIcon;
    }

    protected void setIcon(@NotNull Icon icon) {
        this.myIcon = icon;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    protected void setName(@NotNull String name) {
        this.myName = name;
    }

    @Nullable
    public Psi getSource() {
        return (Psi)this.mySource.getElement();
    }

    @Nullable
    public abstract Collection<? extends OCSymbol> getTargets();

    public abstract void navigate(@Nullable MouseEvent var1, @Nullable Editor var2);

    @NotNull
    public String getTooltip(@NotNull PsiElement psiElement) {
        return this.getName();
    }

    @NotNull
    public PsiElementListCellRenderer<PsiElement> createRenderer(@NotNull Psi source, PsiElement @NotNull [] targets) {
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
        return new CellRenderer(gotoData);
    }

    @Nullable
    protected static <T> T computeUnderProgress(@Nullable Project project2, @NotNull ThrowableComputable<T, ? extends RuntimeException> task2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!ApplicationManager.getApplication().isWriteAccessAllowed()) {
            ThrowableComputable wrappedTask = () -> ProgressManager.getInstance().computePrioritized(() -> ReadAction.compute((ThrowableComputable)task2));
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(wrappedTask, OCBundle.message("navigation.goto.resolving.target", new Object[0]), true, project2);
        }
        return (T)task2.compute();
    }

    protected static <T> boolean runAndWait(@NotNull String title, int timeoutMilliseconds, @NotNull AtomicReference<T> result2, @NotNull ThrowableComputable<T, ? extends RuntimeException> task2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        ThrowableComputable wrappedTask = () -> ProgressManager.getInstance().computePrioritized(() -> ReadAction.compute((ThrowableComputable)task2));
        AtomicReference exception = new AtomicReference();
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        Future future = ApplicationManager.getApplication().executeOnPooledThread(ConcurrencyUtil.underThreadNameRunnable((String)title, () -> OCGotoAction.lambda$runAndWait$5(wrappedTask, result2, exception, (ProgressIndicator)indicator)));
        try {
            future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            indicator.cancel();
            return false;
        }
        Throwable ex = (Throwable)exception.get();
        if (ex != null && !(ex instanceof ControlFlowException)) {
            ExceptionUtil.rethrowUnchecked((Throwable)((Throwable)exception.get()));
        }
        return true;
    }

    private static /* synthetic */ void lambda$runAndWait$5(ThrowableComputable wrappedTask, AtomicReference result2, AtomicReference exception, ProgressIndicator indicator) {
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            try {
                Object compute2 = wrappedTask.compute();
                result2.set(compute2);
            }
            catch (Throwable thr) {
                exception.set(thr);
            }
        }, indicator);
    }

    private static class CellRenderer
    extends DefaultPsiElementCellRenderer {
        final GotoTargetHandler.GotoData myGotoData;

        private CellRenderer(GotoTargetHandler.GotoData gotoData) {
            this.myGotoData = gotoData;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                return super.getListCellRendererComponent(list, null, index, isSelected, cellHasFocus);
            }
            PsiElementListCellRenderer<PsiElement> gotoRenderer = this.findRenderer((PsiElement)value);
            return gotoRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        @NotNull
        private PsiElementListCellRenderer<PsiElement> findRenderer(@NotNull PsiElement value) {
            return Objects.requireNonNull(GotoTargetHandler.createRenderer((GotoTargetHandler.GotoData)this.myGotoData, (PsiElement)value));
        }

        public String getElementText(PsiElement element) {
            return this.findRenderer(element).getElementText(element);
        }

        @NotNull
        public Comparable getComparingObject(PsiElement element) {
            return super.getComparingObject(element).toString() + element.getTextOffset();
        }
    }
}

