/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCRemoveSuppressionIntentionAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return OCBundle.message("intentions.remove.suppression", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nullable
    private static OCPragma getPragma(PsiElement element) {
        OCPragma pragma = OCElementUtil.getPragmaAt(element);
        return pragma == null || pragma.parsePragma() == null ? null : pragma;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        return element.isValid() && OCRemoveSuppressionIntentionAction.getPragma(element) != null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCFile file2 = (OCFile)element.getContainingFile();
        Document document2 = editor.getDocument();
        OCPragma pragma = OCRemoveSuppressionIntentionAction.getPragma(element);
        if (pragma == null) {
            return;
        }
        Pair<OCPragma.Mode, String> pair = pragma.parsePragma();
        int pragmaTextOffset = OCElementUtil.getRangeWithMacros(pragma).getStartOffset();
        OCPragmaSuppressionUtils.Scope scope = OCPragmaSuppressionUtils.findScope(file2, pragmaTextOffset);
        if (pair != null) {
            if (pair.first == OCPragma.Mode.PUSH || pair.first == OCPragma.Mode.POP || !scope.isTopLevel() && scope.getOwnSettingsCnt() <= 1) {
                OCRemoveSuppressionIntentionAction.removeScope(document2, scope);
            } else {
                OCRemoveSuppressionIntentionAction.removePragma(document2, pragmaTextOffset, scope);
            }
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        }
    }

    private static void removePragma(Document document2, int pragmaTextOffset, OCPragmaSuppressionUtils.Scope scope) {
        for (Pair pair : scope.getSettings().values()) {
            if (((TextRange)pair.first).getStartOffset() != pragmaTextOffset) continue;
            document2.deleteString(((TextRange)pair.first).getStartOffset(), ((TextRange)pair.first).getEndOffset());
            return;
        }
    }

    private static void removeScope(Document document2, OCPragmaSuppressionUtils.Scope scope) {
        ArrayList<Object> ranges = new ArrayList<Object>();
        TextRange push = scope.getPush();
        TextRange pop = scope.getPop();
        if (push != null) {
            ranges.add(push);
        }
        if (pop != null) {
            ranges.add(pop);
        }
        for (Pair pair : scope.getSettings().values()) {
            if (push != null && ((TextRange)pair.first).getStartOffset() <= push.getStartOffset()) continue;
            ranges.add(pair.first);
        }
        ContainerUtil.sort(ranges, Comparator.comparingInt(TextRange::getStartOffset));
        for (int i2 = ranges.size() - 1; i2 >= 0; --i2) {
            TextRange range = (TextRange)ranges.get(i2);
            document2.deleteString(range.getStartOffset(), range.getEndOffset());
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

