/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import org.jetbrains.annotations.NotNull;

public class OCUnusedInstanceVariableInspection
extends OCUnusedObjCInspection {
    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor(this){

            @Override
            public void visitInstanceVariableList(OCInstanceVariablesList list) {
                for (OCDeclaration declaration : list.getDeclarations()) {
                    for (OCDeclarator declarator : declaration.getDeclarators()) {
                        this.checkSymbolUsed(declarator, declarator.getSymbol());
                    }
                }
            }

            @Override
            public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator) {
                if (symbol instanceof OCInstanceVariableSymbol && (((OCInstanceVariableSymbol)symbol).getParent() instanceof OCInterfaceSymbol || symbol.getAssociatedSymbol(declarator.getProject()) == null)) {
                    this.checkSymbolUsed(declarator, symbol);
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }
}

