/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ArgumentSelectionDefectsInspection
extends OurClangTidyInspection {
    public static final String DISPLAY_NAME = "Argument selection defects";
    public static final String CHECK_NAME = "clion-argument-selection-defects";
    public static final String SHORT_PARAMETERS_NAMES_OPTION = "clion-argument-selection-defects.ShortParametersNames";
    public boolean myAllowShortParametersNames = true;

    @Override
    public String getCheckName() {
        return CHECK_NAME;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public JComponent createOptionsPanel() {
        GridBag bag = new GridBag().setDefaultAnchor(18).setDefaultFill(2).setDefaultWeightX(1.0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)this.createShortParametersNamesCheckbox(), bag.nextLine().weighty(0.0));
        panel2.add((Component)new Spacer(), bag.nextLine().weighty(1.0));
        return panel2;
    }

    @NotNull
    public JComponent createShortParametersNamesCheckbox() {
        final JBCheckBox checkBox = new JBCheckBox(OCInspectionsBundle.message("inspections.argument.selection.defects.checkbox", new Object[0]), this.myAllowShortParametersNames);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ArgumentSelectionDefectsInspection.this.myAllowShortParametersNames = checkBox.isSelected();
                ArgumentSelectionDefectsInspection.this.addOrReplaceCheckOption(ArgumentSelectionDefectsInspection.SHORT_PARAMETERS_NAMES_OPTION, Integer.toString(ArgumentSelectionDefectsInspection.this.myAllowShortParametersNames ? 1 : 0));
            }
        });
        return checkBox;
    }

    public boolean isAllowShortParametersNames() {
        return this.myAllowShortParametersNames;
    }

    public void setAllowShortParametersNames(boolean allowShortParametersNames) {
        this.myAllowShortParametersNames = allowShortParametersNames;
    }
}

