/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateConstructorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateConstructorContext> {
    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to be Initialized";
    }

    @Override
    @NotNull
    protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context2) {
        return new OCGenerateConstructorContext(parent, context2);
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(final @NotNull OCCaretLocation location, @NotNull OCGenerateConstructorContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        List<OCFunctionSymbol> chosenCtors;
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        OCStructSymbol parent = (OCStructSymbol)actionContext.getParent();
        PsiElement element = parent.locateDefinition(location.getProject());
        if (!(element instanceof OCStructLike)) {
            return Collections.emptyList();
        }
        OCStructLike structLike = (OCStructLike)element;
        final OCResolveContext context2 = location.createContext();
        if (this.addParametersForBaseClasses()) {
            parent.processBaseClasses(OCResolveContext.forSymbol(parent, location.getProject()), (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                    ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)collector, context2);
                    if (!collector.getResults().isEmpty()) {
                        baseConstructors.add(collector.getResults());
                    }
                }
                return true;
            });
        }
        if ((chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, location.getProject())) == null) {
            return Collections.emptyList();
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        HashSet<String> existingNames = new HashSet<String>();
        ArrayList<String> initList = new ArrayList<String>();
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            OCDeclaratorSymbol param;
            OCType type;
            if (baseConstructor.getType().hasNoParameters()) continue;
            StringBuilder callBase = new StringBuilder(baseConstructor.getName()).append("(");
            boolean first = true;
            Iterator<OCDeclaratorSymbol> iterator2 = baseConstructor.getParameterSymbols().iterator();
            while (iterator2.hasNext() && !((type = (param = iterator2.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
                String paramName = param.isUnnamed() ? OCNameSuggester.suggestForType(param.getType(), null, "", context2).iterator().next() : param.getName();
                String name = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, paramName, null, existingNames, actionContext.getProject());
                existingNames.add(name);
                paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
                paramNames.add(name);
                if (!first) {
                    callBase.append(",");
                }
                callBase.append(name);
                first = false;
            }
            callBase.append(")");
            initList.add(callBase.toString());
        }
        for (OCDeclaratorSymbol field : fields) {
            String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, actionContext.getProject());
            name = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, name, null, existingNames, actionContext.getProject());
            existingNames.add(name);
            OCType type = field.getType();
            paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
            paramNames.add(name);
            initList.add(field.getName() + "(" + name + ")");
        }
        OCFunctionType funcType = new OCFunctionType(OCVoidType.instance(), paramTypes, paramNames);
        final OCType resolved = funcType.resolve(context2);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                OCType type;
                return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && (type = symbol.getResolvedType(context2)) instanceof OCFunctionType && new OCTypeEqualityVisitor(type, false, OCResolveContext.forPsi((PsiElement)location.getFile())).isFunctionSignatureEqual(resolved);
            }
        };
        parent.processMembers((String)null, (Processor<? super OCSymbol>)finder);
        if (finder.isFound()) {
            int code;
            String message = "Constructor " + ((OCFunctionSymbol)finder.getFoundValue()).getSignatureWithoutParamNames() + " is already defined.\nDo you wish to continue?";
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 1 : Messages.showYesNoDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code != 0) {
                return Collections.emptyList();
            }
        }
        OCFakeFunctionSymbolBuilder builder2 = new OCFakeFunctionSymbolBuilder(parent.getName()).setIsCtorOrDtor(true).setContainer(parent).setVisibility(OCVisibility.PUBLIC);
        for (OCDeclaratorSymbol param : ContainerUtil.zip(paramTypes, paramNames)) {
            builder2.addParam((OCType)((Pair)param).first, (String)((Pair)param).second);
        }
        String body = (initList.isEmpty() ? "" : ":" + StringUtil.join(initList, (String)",")) + "{}";
        return OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, parent, Collections.singletonList(builder2.get()), Collections.singletonList(body), this.getInlinePolicy(actionContext));
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateConstructorContext context2) {
        return true;
    }

    @Override
    protected boolean allowMultiSelection(OCGenerateConstructorContext context2) {
        return ((OCStructSymbol)context2.getParent()).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    public static List<OCFunctionSymbol> chooseBaseConstructors(List<Collection<OCFunctionSymbol>> allBaseConstructors, Project project2) {
        ArrayList<OCFunctionSymbol> chosenCtors = new ArrayList<OCFunctionSymbol>();
        for (Collection<OCFunctionSymbol> ctors : allBaseConstructors) {
            if (ctors.size() > 1) {
                OCFunctionSymbol ctr = OCGenerateConstructorHandler.chooseConstructor(ctors, project2);
                if (ctr != null) {
                    chosenCtors.add(ctr);
                    continue;
                }
                return null;
            }
            OCFunctionSymbol ctor = (OCFunctionSymbol)ContainerUtil.getFirstItem(ctors);
            if (ctor == null || ctor.canBeCalledWithoutArguments()) continue;
            chosenCtors.add(ctor);
        }
        return chosenCtors;
    }

    @Nullable
    private static OCFunctionSymbol chooseConstructor(Collection<OCFunctionSymbol> constructors, Project project2) {
        OCMemberChooser chooser = new OCMemberChooser((OCMemberChooserObject[])ContainerUtil.map2Array(constructors, OCMemberChooserObject.class, symbol -> new OCMemberChooserObject((OCSymbol)symbol, null, project2, (OCFunctionSymbol)symbol, project2){
            final /* synthetic */ OCFunctionSymbol val$symbol;
            final /* synthetic */ Project val$project;
            {
                this.val$symbol = oCFunctionSymbol;
                this.val$project = project3;
                super(symbol, parentsMap, project2);
            }

            @Override
            @Nullable
            public MemberChooserObject getParentNodeDelegate() {
                return new OCMemberChooserObject(this.val$symbol.getParent(), null, this.val$project);
            }
        }), false, false, Collections.emptyList(), null, project2);
        chooser.setTitle(OCBundle.message("generate.choose.base.class.constructor", new Object[0]));
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        List<OCMemberChooserObject> chosenElements = chooser.getChosenElements();
        assert (chosenElements != null && chosenElements.size() == 1);
        return (OCFunctionSymbol)chosenElements.get(0).getSymbol();
    }

    protected boolean addParametersForBaseClasses() {
        return true;
    }
}

