/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCObjCActionContext<M extends OCMemberSymbol>
extends OCActionContext<OCClassSymbol, M> {
    protected OCClassSymbol myInterfaceSymbol;
    protected OCImplementationSymbol myImplementationSymbol;
    protected OCObjectType myType;

    public OCObjCActionContext(OCClassSymbol symbol, @NotNull PsiElement context2, OCObjectType type) {
        super(symbol, context2);
        this.myInterfaceSymbol = symbol != null ? symbol.getInterfaceOrProtocol(this.getProject()) : null;
        this.myImplementationSymbol = symbol != null ? symbol.getImplementation(this.getProject()) : null;
        this.myType = type;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myImplementationSymbol != null && this.myInterfaceSymbol != null && this.getType() != null;
    }

    @Override
    public List<? extends OCSymbol> getSymbolsToModify() {
        return Arrays.asList(this.myInterfaceSymbol, this.myImplementationSymbol);
    }

    @Override
    @NotNull
    public Collection<M> getMemberCandidates() {
        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
        this.myInterfaceSymbol.processMembers(this.getMemberSymbolClass(), collector);
        return collector.getResults();
    }

    @NotNull
    protected Class getMemberSymbolClass() {
        return OCMemberSymbol.class;
    }

    public OCClassSymbol getInterfaceSymbol() {
        return this.myInterfaceSymbol;
    }

    public OCImplementationSymbol getImplementationSymbol() {
        return this.myImplementationSymbol;
    }

    public OCObjectType getType() {
        return this.myType;
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> candidates) {
        HashMap<OCSymbol, OCSymbol> map2 = new HashMap<OCSymbol, OCSymbol>();
        for (OCMemberSymbol candidate : candidates) {
            OCClassSymbol parent = candidate.getParent();
            map2.put(candidate, parent);
            if (parent.getCategoryName() == null) continue;
            map2.put(parent, parent.getMainInterface(this.getProject()));
        }
        for (OCObjectType type = this.myType; type != null; type = type.getSuperType()) {
            for (OCProtocolSymbol protocol : type.getAllProtocols()) {
                if (map2.containsKey(protocol)) continue;
                map2.put(protocol, type.getClassSymbol());
            }
        }
        return map2;
    }
}

