/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCPreprocessorFormatterData {
    public int directiveNestLevel = 0;
    public ArrayList<OCIndentInfo> directiveIndent = new ArrayList();

    @NotNull
    public OCIndentInfo getIndentAtLevel() {
        assert (this.directiveNestLevel >= 0 && this.directiveNestLevel < this.directiveIndent.size());
        return this.directiveIndent.get(this.directiveNestLevel);
    }

    public void setIndentAtLevel(OCIndentInfo indents) {
        assert (this.directiveNestLevel >= 0);
        if (this.directiveNestLevel >= this.directiveIndent.size()) {
            this.directiveIndent.add(this.directiveNestLevel, indents);
        } else {
            this.directiveIndent.set(this.directiveNestLevel, indents);
        }
    }

    public OCIndentInfo getIndents(boolean resetCodeIndent, IElementType tokenType, OCCodeStyleSettings ocCodeStyleSettings, boolean fromFirst) {
        OCIndentInfo indents;
        OCIndentInfo level;
        OffsetType baseIndentType = null;
        int curIndentSizeInSpaces = 0;
        int ifNestLevel = 0;
        if (OCTokenTypes.END_IF_DIRECTIVES.contains(tokenType)) {
            --this.directiveNestLevel;
            if (this.directiveNestLevel < 0) {
                this.directiveNestLevel = 0;
            } else {
                level = this.getIndentAtLevel();
                curIndentSizeInSpaces = level.ifIndentSizeInSpaces;
                baseIndentType = level.baseIndentType;
                ifNestLevel = level.ifNestLevel;
            }
        }
        if (baseIndentType == null) {
            if (ocCodeStyleSettings.KEEP_DIRECTIVE_AT_FIRST_COLUMN && fromFirst) {
                baseIndentType = OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = this.directiveNestLevel;
            } else if (this.directiveNestLevel == 0) {
                baseIndentType = ocCodeStyleSettings.INDENT_DIRECTIVE_AS_CODE ? OffsetType.DIRECTIVE_RELATIVE_CODE : OffsetType.DIRECTIVE_ABSOLUTE;
                ifNestLevel = 0;
                curIndentSizeInSpaces = 0;
            } else {
                --this.directiveNestLevel;
                level = this.getIndentAtLevel();
                baseIndentType = level.baseIndentType;
                ifNestLevel = level.ifNestLevel;
                ++this.directiveNestLevel;
                int n = curIndentSizeInSpaces = resetCodeIndent ? 0 : level.ifIndentSizeInSpaces + ocCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE;
            }
        }
        if ((indents = new OCIndentInfo(baseIndentType, curIndentSizeInSpaces, ifNestLevel, tokenType)).isIndentStarter()) {
            this.setIndentAtLevel(indents);
            ++this.directiveNestLevel;
        }
        return indents;
    }

    public static class OCIndentInfo {
        public OffsetType baseIndentType;
        public final int ifIndentSizeInSpaces;
        public final int ifNestLevel;
        public final IElementType tokenType;

        public OCIndentInfo(@NotNull OffsetType baseIndentType, int ifIndentSizeInSpaces, int ifNestLevel, IElementType tokenType) {
            this.baseIndentType = baseIndentType;
            this.ifIndentSizeInSpaces = ifIndentSizeInSpaces;
            this.ifNestLevel = ifNestLevel;
            this.tokenType = tokenType;
        }

        public boolean isIndentStarter() {
            return OCFormatterUtil.FORMAT_DIRECTIVES_INCREASE_INDENT.contains(this.tokenType);
        }

        public boolean resetIndentInDirectiveSequence() {
            assert (this.baseIndentType == OffsetType.DIRECTIVE_POSTPONE);
            return this.ifIndentSizeInSpaces == 0;
        }

        @NotNull
        @Contract(value="_, _ -> new", pure=true)
        public static OCIndentInfo createCodeInfo(@NotNull OffsetType baseIndentType, int ifIndentSizeInSpaces) {
            return new OCIndentInfo(baseIndentType, ifIndentSizeInSpaces, -1, null);
        }

        @NotNull
        @Contract(value="_, _ -> new", pure=true)
        public static OCIndentInfo createPostponedDirectiveInfo(@NotNull IElementType tokenType, boolean resetIndentInDirectiveSequence) {
            return new OCIndentInfo(OffsetType.DIRECTIVE_POSTPONE, resetIndentInDirectiveSequence ? 0 : -1, -1, tokenType);
        }
    }

    public static enum OffsetType {
        CODE_RELATIVE_PREV,
        CODE_AS_IS,
        DIRECTIVE_POSTPONE,
        DIRECTIVE_RELATIVE_CODE,
        DIRECTIVE_ABSOLUTE;

    }
}

