/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.typing;

import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardStructureDetector;
import org.jetbrains.annotations.NotNull;

public class OCBackwardBlockDetector
extends OCBackwardStructureDetector {
    @NotNull
    private final IElementType myRight;
    @NotNull
    private final IElementType myLeft;

    public OCBackwardBlockDetector(@NotNull IElementType left, @NotNull IElementType right) {
        this.myRight = right;
        this.myLeft = left;
    }

    @Override
    public boolean next(@NotNull OCBackwardStructureDetector.TokenIterator it) {
        block3: {
            it.skipWhitespaces();
            if (it.atEnd() || it.getTokenType() != this.myRight) {
                return false;
            }
            int balance = 1;
            while (true) {
                it.retreat();
                it.skipWhitespaces();
                if (it.atEnd()) break block3;
                IElementType tt = it.getTokenType();
                if (tt == this.myRight) {
                    ++balance;
                    continue;
                }
                if (tt == this.myLeft && --balance == 0) break;
            }
            it.retreat();
            return true;
        }
        return false;
    }
}

