/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.names.OCDumbTypeNameVisitor;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CPPAutoTypeForRangedForLoop
extends Macro {
    public static final String MACRO_NAME = "autoTypeForRangedForLoop";
    private static final String[] OPTIONS = new String[]{"const auto&", "auto&", "auto&&", "auto"};

    public String getName() {
        return MACRO_NAME;
    }

    public String getPresentableName() {
        return "autoTypeForRangedForLoop()";
    }

    @Nullable
    public Result calculateResult(Expression @NotNull [] params, @NotNull ExpressionContext context2) {
        return new TextResult(CPPAutoTypeForRangedForLoop.getTypeString(0, context2.getProject()));
    }

    public LookupElement @Nullable [] calculateLookupItems(Expression @NotNull [] params, @NotNull ExpressionContext context2) {
        Project project2 = context2.getProject();
        Editor editor = context2.getEditor();
        if (editor == null) {
            return LookupElement.EMPTY_ARRAY;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return LookupElement.EMPTY_ARRAY;
        }
        return (LookupElement[])IntStream.range(0, 4).mapToObj(i2 -> LookupElementBuilder.create((String)CPPAutoTypeForRangedForLoop.getTypeString(i2, project2))).toArray(LookupElement[]::new);
    }

    @NotNull
    private static String getTypeString(int index, @NotNull Project project2) {
        return new OCDumbTypeNameVisitor(0, project2).getName(CPPAutoTypeForRangedForLoop.getType(index, project2));
    }

    @NotNull
    private static OCType getType(int index, @NotNull Project project2) {
        OCAutoType autoType = new OCAutoType();
        switch (index) {
            case 0: {
                return OCCppReferenceType.to(autoType.cloneWithConstModifier(project2));
            }
            case 1: {
                return OCCppReferenceType.to(autoType);
            }
            case 2: {
                return OCCppReferenceType.to(autoType, true, false, false);
            }
            case 3: {
                return autoType;
            }
        }
        OCLog.LOG.error("Invalid index " + index);
        return autoType;
    }

    public boolean isAcceptableInContext(TemplateContextType context2) {
        return context2 instanceof OCCodeContextType;
    }
}

