/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.editor.completion.ConsumedTokenFinder;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodInsertHandler
implements InsertHandler<LookupElement> {
    @NotNull
    protected final OCMethodSymbol mySymbol;
    @Nullable
    private final PsiElement myContextExpression;
    @NotNull
    private final String myQualifier;
    private final boolean myInsideSendMessage;

    MethodInsertHandler(@NotNull OCMethodSymbol symbol, @Nullable PsiElement contextExpression, boolean insideSendMessage, @NotNull String qualifier) {
        this.mySymbol = symbol;
        this.myContextExpression = contextExpression;
        this.myInsideSendMessage = insideSendMessage;
        this.myQualifier = qualifier;
    }

    @NotNull
    protected String getInsertionDeclaration(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        OCMethod method;
        assert (this.isInDeclarationContext());
        assert (context2.getStartOffset() == context2.getEditor().getCaretModel().getOffset() - item.getLookupString().length());
        assert (context2.getTailOffset() == context2.getEditor().getCaretModel().getOffset());
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.myQualifier);
        if (!this.myQualifier.isEmpty()) {
            insertion.append(' ');
        }
        OCElement body = null;
        if (this.myQualifier.isEmpty() && context2.getCompletionChar() == '\t') {
            MethodInsertHandler.smartNormalizeNextSelector(context2, item);
            method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(context2.getStartOffset()), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class});
            body = method != null ? method.getBody() : null;
        }
        MethodInsertHandler.appendParameters(this.mySymbol, context2, insertion, false);
        if (body != null) {
            int endOffset = body.getRangeWithMacros().getStartOffset();
            context2.setTailOffset(endOffset);
        }
        if ((method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)context2.getFile().findElementAt(context2.getStartOffset()), OCMethod.class, (boolean)true, (Class[])new Class[]{OCImplementation.class})) != null && method.getReturnTypeElement() == null) {
            String name = this.mySymbol.getEffectiveType(method.getProject()).getBestNameInContext(method, OCElementUtil.getReturnTypeText(this.mySymbol, method.getProject()));
            insertion.insert(0, "(" + name + ")");
        }
        if (body == null) {
            OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)context2.getFile(), OCCodeStyleSettings.class);
            insertion.append(settings.SEMICOLON_AFTER_METHOD_SIGNATURE ? ";" : "{ }");
        }
        return insertion.toString();
    }

    @NotNull
    protected String getInsertionCall(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        boolean noClosingBracketMatched;
        int autoOpenOffset;
        boolean smartInsert;
        assert (!this.isInDeclarationContext());
        assert (context2.getStartOffset() == context2.getEditor().getCaretModel().getOffset() - item.getLookupString().length());
        assert (context2.getTailOffset() == context2.getEditor().getCaretModel().getOffset());
        StringBuilder insertion = new StringBuilder();
        insertion.append(this.myQualifier);
        if (!this.myQualifier.isEmpty()) {
            insertion.append(' ');
        }
        boolean bl = smartInsert = this.myQualifier.isEmpty() && context2.getCompletionChar() == '\t';
        if (smartInsert) {
            MethodInsertHandler.smartNormalizeNextSelector(context2, item);
        }
        boolean insertedOpeningBracket = (autoOpenOffset = this.autoOpenBracket(context2, item)) >= 0;
        boolean closingBracketNecessary = autoOpenOffset != Integer.MIN_VALUE;
        OCSendMessageExpression expr = MethodInsertHandler.getSendMessage(context2.getFile(), context2.getStartOffset());
        boolean isSmart = expr != null;
        boolean bl2 = noClosingBracketMatched = isSmart && expr.getNode().getLastChildNode().getElementType() != OCTokenTypes.RBRACKET;
        if (isSmart && smartInsert) {
            int endOffset;
            List<OCMessageArgument> args = expr.getArguments();
            int usedArguments = MethodInsertHandler.appendParameters(this.mySymbol, context2, insertion, true, args, !noClosingBracketMatched);
            if (usedArguments < args.size()) {
                endOffset = usedArguments > 0 ? args.get(usedArguments - 1).getRangeWithMacros().getEndOffset() : MethodInsertHandler.offsetBeforeExpression(args.get(0));
                closingBracketNecessary = false;
            } else {
                endOffset = expr.getRangeWithMacros().getEndOffset();
                if (noClosingBracketMatched) {
                    closingBracketNecessary = false;
                }
            }
            insertion.append(']');
            context2.setTailOffset(endOffset);
        } else {
            OCElement lastNonWsChild;
            MethodInsertHandler.appendParameters(this.mySymbol, context2, insertion, true);
            if (isSmart && !noClosingBracketMatched && (lastNonWsChild = (OCElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expr.getLastChild())) != null && context2.getTailOffset() < lastNonWsChild.getRangeWithMacros().getEndOffset()) {
                noClosingBracketMatched = true;
            }
        }
        if (!this.myQualifier.isEmpty() && !this.myInsideSendMessage || closingBracketNecessary && (isSmart ? noClosingBracketMatched || ConsumedTokenFinder.consumedClosingBracketOfParent(expr) : insertedOpeningBracket || !MethodInsertHandler.nextIsAClosingBracket(context2.getFile(), context2.getTailOffset()))) {
            insertion.append(']');
        }
        return insertion.toString();
    }

    private static void smartNormalizeNextSelector(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Document document2 = context2.getDocument();
        int tailOffset = context2.getTailOffset();
        if (item.getLookupString().endsWith(":")) {
            CharSequence text = document2.getImmutableCharSequence();
            for (int i2 = tailOffset; i2 < text.length(); ++i2) {
                char c = text.charAt(i2);
                if (c == ':') {
                    tailOffset = i2 + 1;
                    break;
                }
                if (!Character.isSpaceChar(c)) break;
            }
            document2.replaceString(context2.getStartOffset(), tailOffset, (CharSequence)"xxx:");
        } else {
            document2.replaceString(context2.getStartOffset(), tailOffset, (CharSequence)"xxx");
        }
        context2.commitDocument();
    }

    public static void appendParameters(@NotNull OCMethodSymbol methodSymbol, @NotNull InsertionContext context2, @NotNull StringBuilder insertion, boolean template) {
        MethodInsertHandler.appendParameters(methodSymbol, context2, insertion, template, Collections.emptyList(), false);
    }

    public static int appendParameters(@NotNull OCMethodSymbol methodSymbol, @NotNull InsertionContext context2, @NotNull StringBuilder insertion, boolean template, @NotNull List<OCMessageArgument> args, boolean eager) {
        List<OCMethodSymbol.SelectorPartSymbol> selectors = methodSymbol.getSelectors();
        int varargIdx = methodSymbol.isVararg() ? selectors.size() - 1 : Integer.MAX_VALUE;
        int usedArgs = 0;
        boolean matchMore = true;
        int size = selectors.size();
        for (int i2 = 0; i2 < size; ++i2) {
            if (i2 > 0) {
                insertion.append(' ');
            }
            OCMethodSymbol.SelectorPartSymbol selector = selectors.get(i2);
            insertion.append(selector.getSelectorName());
            OCDeclaratorSymbol param = selector.getParameter();
            if (param == null) {
                if (usedArgs >= args.size() || args.get(usedArgs).getArgumentExpression() != null) continue;
                ++usedArgs;
                continue;
            }
            if (matchMore && usedArgs < args.size()) {
                OCExpression arg = args.get(usedArgs).getArgumentExpression();
                if (arg == null) {
                    ++usedArgs;
                } else {
                    if (eager || arg.getPrevSibling().getText().indexOf(10) < 0) {
                        insertion.append(arg.getTextWithMacros());
                        ++usedArgs;
                        continue;
                    }
                    matchMore = false;
                }
            }
            if (template) {
                insertion.append("<#");
            }
            MethodInsertHandler.appendParameterName(insertion, context2.getFile(), param);
            if (i2 == varargIdx) {
                insertion.append(", ...");
            }
            if (!template) continue;
            insertion.append("#>");
        }
        return usedArgs;
    }

    private int autoOpenBracket(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        this.adjustDotSyntax(context2);
        int autoOpenOffset = this.calculateAutoOpenOffset(context2, item);
        if (autoOpenOffset >= 0) {
            context2.getDocument().insertString(autoOpenOffset, (CharSequence)"[");
            context2.commitDocument();
            OCChangeUtil.reformatTextIfNotInjected(context2.getFile(), autoOpenOffset, autoOpenOffset + 2);
        }
        return autoOpenOffset;
    }

    private static int offsetBeforeExpression(@NotNull OCMessageArgument messageArgument) {
        OCArgumentSelector selector = messageArgument.getArgumentSelector();
        return selector.getRangeWithMacros().getEndOffset();
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        if (this.isInDeclarationContext()) {
            String insertion = this.getInsertionDeclaration(context2, item);
            context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)insertion);
            CallableInsertUtils.moveCaretToCallableBody(context2);
            OCChangeUtil.reformatTextIfNotInjected(context2.getFile(), context2.getStartOffset(), context2.getStartOffset() + insertion.length());
        } else {
            this.handleCall(context2, item);
        }
    }

    public void handleCall(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        String insertion = this.getInsertionCall(context2, item);
        context2.getDocument().replaceString(context2.getStartOffset(), context2.getTailOffset(), (CharSequence)insertion);
        context2.commitDocument();
        this.postInsertionHook(context2);
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context2.getProject());
        foldManager.updateFoldRegions(context2.getEditor());
        MethodInsertHandler.advanceTailOffsetToEndOffset(context2);
        MethodInsertHandler.advanceTailOffsetOverWs(context2);
        MethodInsertHandler.insertTrailingSpacing(context2);
        PsiFile file2 = context2.getFile();
        if (file2 instanceof OCFile && !OCFileSymbols.isSymbolImported((OCFile)file2, this.mySymbol)) {
            OCImportSymbolFix.fixAfterCompletionAtOffset(context2.getEditor(), file2, context2.getStartOffset(), this.mySymbol);
        }
        if (context2.getCompletionChar() == '(' && insertion.endsWith(")") || context2.getCompletionChar() == ']') {
            context2.setAddCompletionChar(false);
        }
        MethodInsertHandler.reformatCall(context2);
        MethodInsertHandler.moveCaretOffset(context2);
    }

    private static void advanceTailOffsetToEndOffset(@NotNull InsertionContext context2) {
        OCSendMessageExpression call = MethodInsertHandler.getSendMessage(context2.getFile(), context2.getStartOffset());
        if (call == null) {
            return;
        }
        int endOffset = call.getRangeWithMacros().getEndOffset();
        if (context2.getTailOffset() < endOffset) {
            context2.setTailOffset(endOffset);
        }
    }

    private static void advanceTailOffsetOverWs(@NotNull InsertionContext context2) {
        char nextChar;
        int tailOffset;
        Document document2 = context2.getDocument();
        CharSequence documentText = document2.getImmutableCharSequence();
        int i2 = tailOffset = context2.getTailOffset();
        while (i2 < documentText.length() && Character.isSpaceChar(nextChar = documentText.charAt(i2))) {
            tailOffset = i2++;
        }
        context2.setTailOffset(tailOffset);
    }

    private static void reformatCall(@NotNull InsertionContext context2) {
        PsiFile file2 = context2.getFile();
        PostprocessReformattingAspect.getInstance((Project)file2.getProject()).doPostponedFormatting();
        Document document2 = context2.getDocument();
        CharSequence documentText = document2.getImmutableCharSequence();
        int tailOffset = context2.getTailOffset();
        OffsetKey nextNonWs = OffsetKey.create((String)"nonWsAfterTail", (boolean)true);
        context2.getOffsetMap().addOffset(nextNonWs, CharArrayUtil.shiftForward((CharSequence)documentText, (int)tailOffset, (String)" \t\n"));
        if (context2.getStartOffset() < tailOffset && tailOffset < documentText.length() && documentText.charAt(tailOffset - 1) == ';') {
            if (context2.getCompletionChar() == ' ') {
                document2.insertString(tailOffset, (CharSequence)" ");
                context2.commitDocument();
                context2.setAddCompletionChar(false);
            }
            OCChangeUtil.reformatTextIfNotInjected(file2, tailOffset, tailOffset + 1);
            context2.setTailOffset(tailOffset);
        }
        OCChangeUtil.reformatTextIfNotInjected(file2, context2.getStartOffset(), tailOffset);
        if (!context2.getOffsetMap().containsOffset(InsertionContext.TAIL_OFFSET)) {
            context2.setTailOffset(context2.getOffset(nextNonWs));
        }
    }

    private static void insertTrailingSpacing(@NotNull InsertionContext context2) {
        int tailOffset = context2.getTailOffset();
        if (tailOffset <= context2.getStartOffset() || context2.getCompletionChar() == ' ') {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)context2.getProject());
        int spacing = codeStyleManager.getSpacing(context2.getFile(), tailOffset);
        if (spacing < 1) {
            return;
        }
        context2.getDocument().insertString(tailOffset, (CharSequence)" ");
        context2.commitDocument();
    }

    private static void moveCaretOffset(@NotNull InsertionContext context2) {
        CharSequence documentText = context2.getDocument().getImmutableCharSequence();
        int firstParamStart = StringUtil.indexOf((CharSequence)documentText, (CharSequence)"<#", (int)context2.getStartOffset(), (int)context2.getTailOffset());
        int firstParamEnd = firstParamStart >= 0 ? StringUtil.indexOf((CharSequence)documentText, (CharSequence)"#>", (int)firstParamStart, (int)context2.getTailOffset()) : -1;
        int caretOffset = context2.getTailOffset();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < caretOffset) {
            context2.setAddCompletionChar(false);
            caretOffset = firstParamStart;
            context2.getEditor().getSelectionModel().setSelection(caretOffset, firstParamEnd + 2);
        }
        context2.getEditor().getCaretModel().moveToOffset(caretOffset);
    }

    private void adjustDotSyntax(@NotNull InsertionContext context2) {
        if (!(this.myContextExpression instanceof OCQualifiedExpression)) {
            return;
        }
        if (this.mySymbol.isGetter(OCResolveContext.forPsi((PsiElement)context2.getFile())) && context2.getCompletionChar() != ']') {
            return;
        }
        TextRange range = ((OCQualifiedExpression)this.myContextExpression).getQualifyingToken().getTextRange();
        context2.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)" ");
    }

    private int calculateAutoOpenOffset(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        PsiElement prev;
        Document document2 = context2.getDocument();
        PsiFile file2 = context2.getFile();
        MethodSelectorCompletionContributor.Context completionCtx = (MethodSelectorCompletionContributor.Context)MethodSelectorCompletionContributor.CONTEXT.get((UserDataHolder)item);
        PsiElement originalReceiver = completionCtx == null ? null : completionCtx.getReceiver();
        int autoOpenOffset = -1;
        if (this.myContextExpression instanceof OCQualifiedExpression) {
            if (this.mySymbol.isGetter(OCResolveContext.forPsi((PsiElement)file2)) && context2.getCompletionChar() != ']') {
                return Integer.MIN_VALUE;
            }
            autoOpenOffset = this.myContextExpression.getTextRange().getStartOffset();
        } else if (originalReceiver != null && ((prev = OCElementUtil.getPrevSignificantSibling(originalReceiver)) == null || prev.getNode().getElementType() != OCTokenTypes.LBRACKET || prev.getParent() instanceof OCNSArrayLiteral)) {
            OCElement receiver;
            TextRange originalRange = originalReceiver.getTextRange();
            CharSequence docText = document2.getImmutableCharSequence();
            int nonWs = CharArrayUtil.shiftBackward((CharSequence)docText, (int)(context2.getStartOffset() - 1), (String)" \t\n");
            Class stopAt = originalReceiver instanceof OCBlockExpression ? OCCallable.class : OCBlockStatement.class;
            for (receiver = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCExpression.class, (boolean)false, (Class[])new Class[]{stopAt}); !originalRange.isEmpty() && receiver != null && receiver.getParent() instanceof OCExpression && receiver.getTextRange().getLength() < originalRange.getLength(); receiver = (OCExpression)receiver.getParent()) {
            }
            if (receiver == null) {
                receiver = (OCElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCMacroCall.class, (boolean)false, (Class[])new Class[]{stopAt});
            }
            if (receiver != null) {
                autoOpenOffset = receiver.getTextRange().getStartOffset();
            } else {
                OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)nonWs, OCTypeElement.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
                if (typeElement != null) {
                    autoOpenOffset = typeElement.getTextRange().getStartOffset();
                }
            }
        }
        return autoOpenOffset;
    }

    protected void postInsertionHook(@NotNull InsertionContext context2) {
        Document document2 = context2.getDocument();
        PsiFile file2 = context2.getFile();
        OCSendMessageExpression call = (OCSendMessageExpression)PsiTreeUtil.findElementOfClassAtOffsetWithStopSet((PsiFile)file2, (int)context2.getStartOffset(), OCSendMessageExpression.class, (boolean)false, (Class[])new Class[]{OCCallable.class});
        if (call != null && this.mySymbol.getReturnType(context2.getProject()).isVoid() && call.getParent() instanceof OCExpressionStatement) {
            OCExpressionStatement st = (OCExpressionStatement)call.getParent();
            if (st.getNode().getLastChildNode().getElementType() == OCTokenTypes.SEMICOLON) {
                return;
            }
            int endOffset = call.getTextRange().getEndOffset();
            document2.insertString(endOffset, (CharSequence)";");
            context2.setTailOffset(++endOffset);
        }
    }

    private static boolean nextIsAClosingBracket(@NotNull PsiFile file2, int offset) {
        PsiElement next;
        for (next = file2.findElementAt(offset); next != null && OCTokenTypes.WHITESPACES.contains(next.getNode().getElementType()); next = next.getNextSibling()) {
        }
        return next != null && next.getNode().getElementType() == OCTokenTypes.RBRACKET;
    }

    private boolean isInDeclarationContext() {
        if (this.myContextExpression == null) {
            return false;
        }
        PsiElement parent = this.myContextExpression.getParent();
        return parent instanceof OCMethodSelectorPart && parent.getParent() instanceof OCMethod;
    }

    @Nullable
    protected static OCSendMessageExpression getSendMessage(@NotNull PsiFile file2, int offset) {
        return (OCSendMessageExpression)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), OCSendMessageExpression.class, (boolean)true, (Class[])new Class[]{OCCallable.class, OCQualifiedExpression.class});
    }

    protected static void appendParameterName(@NotNull StringBuilder insertion, @NotNull PsiFile file2, @NotNull OCDeclaratorSymbol p) {
        insertion.append("(").append(p.getType().getBestNameInContext((PsiElement)file2)).append(')');
        if (!p.isUnnamed()) {
            insertion.append(p.getName());
        }
    }

    @NotNull
    private static String debug(@NotNull InsertionContext context2, @Nullable PsiElement expr) {
        Document document2 = context2.getDocument();
        CaretModel caretModel = context2.getEditor().getCaretModel();
        int caretOffset = caretModel.getOffset();
        TextRange exprRange = expr != null ? (expr instanceof OCElement ? ((OCElement)expr).getRangeWithMacros() : expr.getTextRange()) : null;
        int exprStart = exprRange != null ? exprRange.getStartOffset() : Integer.MIN_VALUE;
        int exprEnd = exprRange != null && exprStart != exprRange.getEndOffset() ? exprRange.getEndOffset() : Integer.MIN_VALUE;
        OCStatement statement2 = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, OCStatement.class);
        TextRange statementRange = statement2 != null ? statement2.getRangeWithMacros() : null;
        int statementStart = statementRange != null ? statementRange.getStartOffset() : Integer.MIN_VALUE;
        int statementEnd = statementRange != null ? statementRange.getEndOffset() : Integer.MIN_VALUE;
        OCStatement nextStatement = (OCStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)statement2, OCStatement.class);
        TextRange nextStatementRange = nextStatement != null ? nextStatement.getRangeWithMacros() : null;
        int nextStatementStart = nextStatementRange != null ? nextStatementRange.getStartOffset() : Integer.MIN_VALUE;
        ContainerUtil.KeyOrderedMultiMap markers = new ContainerUtil.KeyOrderedMultiMap();
        markers.putValue((Object)exprStart, (Object)"<expr>");
        markers.putValue((Object)exprEnd, (Object)"</expr>");
        markers.putValue((Object)statementStart, (Object)"<statement>");
        markers.putValue((Object)statementEnd, (Object)"</statement>");
        markers.putValue((Object)nextStatementStart, (Object)"<nextStatement>");
        markers.putValue((Object)caretOffset, (Object)"<caret>");
        for (OffsetKey offset2 : context2.getOffsetMap().getAllOffsets()) {
            markers.putValue((Object)context2.getOffset(offset2), (Object)("<" + StringUtil.trimEnd((String)offset2.toString(), (String)"Offset") + ">"));
        }
        NavigableSet<Integer> markerOffsets = markers.navigableKeySet().descendingSet();
        CharSequence text = document2.getImmutableCharSequence();
        int startLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)(markerOffsets.lower(Integer.MIN_VALUE) + 1)) - 1;
        int endLine = StringUtil.offsetToLineNumber((CharSequence)text, (int)((Integer)markerOffsets.first() - 1)) + 2;
        int start = StringUtil.lineColToOffset((CharSequence)text, (int)startLine, (int)0);
        int end = StringUtil.lineColToOffset((CharSequence)text, (int)endLine, (int)0) - 1;
        if (start < 0 || text.length() < start) {
            start = 0;
        }
        if (end < 0 || text.length() < end) {
            end = text.length();
        }
        StringBuilder extract = new StringBuilder(text.subSequence(start, end));
        int extractStart = start;
        markerOffsets.forEach(offset -> {
            if (offset >= extractStart) {
                markers.get(offset).forEach(marker -> extract.insert(offset - extractStart, (String)marker));
            }
        });
        return extract.toString();
    }
}

