/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.colors;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    private final Map<OCLexerSettings, OCFileHighlighter> myHighlighters = FactoryMap.create(key -> new OCFileHighlighter((OCLexerSettings)key));

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project2, @Nullable VirtualFile virtualFile) {
        OCLanguageKind languageKind = CLanguageKind.maxLanguage();
        if (virtualFile != null && !(virtualFile instanceof VirtualFileWindow) && virtualFile.isValid() && project2 != null && SymbolTableProvider.isSourceFile(project2, virtualFile)) {
            languageKind = OCLanguageKindCalculator.calculateLanguageKindFast(virtualFile, project2);
        }
        OCLexerSettings settings = OCLexerSettings.forLanguage(languageKind).forHighlighting().allowNullabilityKeywords().allowGccAutoType().allowAvailabilityExpression().allowMsvcExtensions().build();
        return (SyntaxHighlighter)this.myHighlighters.get(settings);
    }
}

