/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTemplateParameterInfoHandler
implements ParameterInfoHandler<OCTemplateArgumentList, Info> {
    @Nullable
    public OCTemplateArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        boolean hasResult;
        int startOffset;
        int offset;
        PsiFile file2 = context2.getFile();
        List<Info> infos = OCTemplateParameterInfoHandler.findInfos(file2, offset = context2.getOffset(), startOffset = context2.getParameterListStart());
        boolean bl = hasResult = !infos.isEmpty();
        if (hasResult) {
            context2.setItemsToShow(infos.toArray());
        }
        return hasResult ? infos.get(0).getList() : null;
    }

    @NotNull
    private static List<Info> findInfos(@Nullable PsiFile file2, int offset, int startOffset) {
        OCTemplateArgumentList list = OCTemplateParameterInfoHandler.findArgumentList(file2, offset, startOffset);
        if (list == null) {
            return Collections.emptyList();
        }
        OCTemplateArgumentsOwner tao = (OCTemplateArgumentsOwner)PsiTreeUtil.getParentOfType((PsiElement)list, OCTemplateArgumentsOwner.class);
        if (tao != null) {
            List<OCTypeParameterSymbol> ps = null;
            for (OCSymbol s : tao.resolveTemplateDeclarations()) {
                if (!(s instanceof OCTemplateSymbol)) continue;
                OCTemplateSymbol candidate = (OCTemplateSymbol)s;
                List<OCTypeParameterSymbol> cs = candidate.getTemplateParameters();
                boolean isVariadic = candidate.isVariadicTemplate();
                if (cs.isEmpty() || ps != null && !isVariadic && ps.size() >= cs.size()) continue;
                ps = cs;
                if (!isVariadic) continue;
                break;
            }
            if (ps != null) {
                return Collections.singletonList(new Info(list, ps));
            }
        }
        return Collections.emptyList();
    }

    public void showParameterInfo(@NotNull OCTemplateArgumentList element, @NotNull CreateParameterInfoContext context2) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context2.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    @Nullable
    public OCTemplateArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        OCTemplateArgumentList list = OCTemplateParameterInfoHandler.findArgumentList(context2.getFile(), context2.getOffset(), context2.getParameterListStart());
        return list == context2.getParameterOwner() ? list : null;
    }

    public void updateParameterInfo(@NotNull OCTemplateArgumentList list, @NotNull UpdateParameterInfoContext context2) {
        int offset = context2.getOffset();
        if (!list.getTextRange().contains(offset)) {
            context2.removeHint();
            return;
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)offset, (IElementType)OCTokenTypes.COMMA);
        context2.setCurrentParameter(index);
        Object[] infos = context2.getObjectsToView();
        for (int i2 = 0; i2 < infos.length; ++i2) {
            Info info = (Info)infos[i2];
            boolean isCompatible = OCTemplateParameterInfoHandler.isApplicable(index, info, list);
            context2.setUIComponentEnabled(i2, isCompatible);
        }
    }

    private static boolean isApplicable(int index, @NotNull Info info, @NotNull OCTemplateArgumentList list) {
        boolean isVariadic;
        List<OCTypeParameterSymbol> params = info.getParameters();
        boolean bl = isVariadic = ContainerUtil.find(params, symbol -> symbol.isVariadic()) != null;
        if (!isVariadic && index >= params.size()) {
            return false;
        }
        List args = list.getArguments();
        int endIndex = Math.min(index + 1, args.size());
        List<OCTypeArgument> arguments = OCSymbolReferenceResolver.getTypeArguments((OCTemplateArgumentsOwner)PsiTreeUtil.getParentOfType((PsiElement)list, OCTemplateArgumentsOwner.class));
        Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
        OCResolveContext resolveCtx = OCResolveContext.forPsi(list);
        for (int i2 = 0; i2 < endIndex; ++i2) {
            OCTypeArgument arg = arguments.get(i2);
            OCTypeParameterSymbol param = params.get(Math.min(i2, params.size() - 1));
            OCTypeUnificationVisitor.UnificationResult res = OCSimpleTypeSubstitution.unify(new OCTypeParameterType(param), arg, substitutionMap, resolveCtx);
            if (res != OCTypeUnificationVisitor.NOT_UNIFIED) continue;
            return false;
        }
        return true;
    }

    public void updateUI(@NotNull Info info, @NotNull ParameterInfoUIContext context2) {
        StringBuilder buffer = new StringBuilder();
        List<OCTypeParameterSymbol> ps = info.getParameters();
        int paramCount = ps.size();
        int currentIdx = Math.min(context2.getCurrentParameterIndex(), paramCount - 1);
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        for (int i2 = 0; i2 < paramCount; ++i2) {
            Object defaultValue;
            String name;
            OCTypeParameterSymbol p = ps.get(i2);
            int startOffset = buffer.length();
            if (p instanceof OCTypeParameterTypeSymbol) {
                buffer.append("typename");
                if (p.isVariadic()) {
                    buffer.append(" ...");
                }
            } else if (p instanceof OCTypeParameterValueSymbol) {
                buffer.append(p.getType().getBestNameInContext(context2.getParameterOwner()));
            }
            if (!"<unnamed>".equals(name = p.getName())) {
                buffer.append(" ").append(name);
            }
            if ((defaultValue = p.getDefaultValue()) != null) {
                OCResolveContext resolveContext = OCResolveContext.forPsi(info.getList());
                String value = defaultValue.getNameForPresentation(OCType.Presentation.BEST, resolveContext, true, 0);
                buffer.append(" = ").append(value);
            }
            int endOffset = buffer.length();
            if (i2 < paramCount - 1) {
                buffer.append(", ");
            }
            if (i2 == currentIdx && context2.isUIComponentEnabled()) {
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
            context2.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context2.isUIComponentEnabled(), false, false, context2.getDefaultParameterColor());
        }
    }

    public boolean couldShowInLookup() {
        return false;
    }

    public Object @Nullable [] getParametersForLookup(LookupElement item, ParameterInfoContext context2) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    private static OCTemplateArgumentList findArgumentList(@Nullable PsiFile file2, int offset, int startOffset) {
        if (file2 == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement element1 = file2.findElementAt(offset);
        PsiElement element2 = file2.findElementAt(startOffset);
        PsiElement element = element1 != null && element2 != null ? PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2) : null;
        return (OCTemplateArgumentList)PsiTreeUtil.getContextOfType((PsiElement)element, OCTemplateArgumentList.class, (boolean)false);
    }

    public static class Info {
        @NotNull
        private final OCTemplateArgumentList myList;
        @NotNull
        private final List<OCTypeParameterSymbol> myParameters;

        public Info(@NotNull OCTemplateArgumentList list, @NotNull List<OCTypeParameterSymbol> params) {
            this.myList = list;
            this.myParameters = params;
        }

        @NotNull
        public OCTemplateArgumentList getList() {
            return this.myList;
        }

        @NotNull
        public List<OCTypeParameterSymbol> getParameters() {
            return this.myParameters;
        }
    }
}

