/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.editor.OCASTFactory;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCEnterInPostponedInjection
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!OCLanguageUtils.isSupported(language)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Editor hostEditor = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (editor == hostEditor && editor instanceof EditorEx) {
            DataContext injectedCaretContext;
            Caret injectedCaret;
            Caret hostCaret = (Caret)CommonDataKeys.CARET.getData(dataContext);
            Project project2 = editor.getProject();
            if (project2 != null && hostCaret != null && PsiDocumentManager.getInstance((Project)project2).isCommitted(editor.getDocument()) && (InjectedLanguageManager.getInstance((Project)project2).mightHaveInjectedFragmentAtOffset(editor.getDocument(), hostCaret.getOffset()) || this.forceGetEditorForInjectedLanguageNoCommit((EditorEx)editor, hostCaret.getOffset()))) {
                editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (Caret)hostCaret, (PsiFile)file2);
            }
            if (editor != hostEditor && (injectedCaret = (Caret)CommonDataKeys.CARET.getData(injectedCaretContext = AnActionEvent.getInjectedDataContext((DataContext)dataContext))) != null && injectedCaret != hostCaret) {
                new EnterHandler(originalHandler).executeWriteAction(editor, injectedCaret, injectedCaretContext);
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    protected boolean forceGetEditorForInjectedLanguageNoCommit(@NotNull EditorEx hostEditor, int caretOffsetInHostEditor) {
        CharSequence text;
        IElementType type;
        HighlighterIterator iterator2 = hostEditor.getHighlighter().createIterator(caretOffsetInHostEditor);
        if (iterator2.atEnd()) {
            return false;
        }
        if (iterator2.getStart() == caretOffsetInHostEditor && OCTokenTypes.WHITESPACES.contains(iterator2.getTokenType())) {
            iterator2.retreat();
            if (iterator2.atEnd()) {
                return false;
            }
        }
        return OCASTFactory.createForDocumentComment(type = iterator2.getTokenType(), text = iterator2.getDocument().getCharsSequence().subSequence(iterator2.getStart(), iterator2.getEnd()), () -> Boolean.TRUE) == Boolean.TRUE || OCTokenTypes.ALL_STRINGS.contains(type) && Registry.is((String)"cidr.force.injected.languages.is.strings");
    }
}

