/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBraceMatcher
extends PairedBraceMatcherAdapter {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)OCTokenTypes.LPAR, (IElementType)OCTokenTypes.RPAR, false), new BracePair((IElementType)OCTokenTypes.LBRACE, (IElementType)OCTokenTypes.RBRACE, true), new BracePair((IElementType)OCTokenTypes.LBRACKET, (IElementType)OCTokenTypes.RBRACKET, false), new BracePair((IElementType)OCTokenTypes.PROTOCOL_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.INTERFACE_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false), new BracePair((IElementType)OCTokenTypes.IMPLEMENTATION_KEYWORD, (IElementType)OCTokenTypes.END_KEYWORD, false)};
    private static final int CONTEXT_ITERATIONS = 100;
    private static final int CURSOR_OFFSET = -1;

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, FileType fileType) {
        if (!super.isLBraceToken(iterator2, fileText, fileType)) {
            return false;
        }
        return OCBraceMatcher.braceIsValidForEditorActions(iterator2, fileText);
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, FileType fileType) {
        if (!super.isRBraceToken(iterator2, fileText, fileType)) {
            return false;
        }
        return OCBraceMatcher.braceIsValidForEditorActions(iterator2, fileText);
    }

    private static boolean braceIsValidForEditorActions(@NotNull HighlighterIterator bracePosition, @NotNull CharSequence fileText) {
        EditorEx editor = OCBraceMatcher.getEditor(bracePosition);
        if (editor == null) {
            return true;
        }
        int braceStart = bracePosition.getStart();
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(braceStart);
        boolean validBraceForPairing = true;
        iterator2.retreat();
        boolean iteratorInTheSameLineWithBrace = true;
        int count = 0;
        while (!iterator2.atEnd()) {
            IElementType ctt = iterator2.getTokenType();
            if (ctt == OCTokenTypes.ELSE_DIRECTIVE || ctt == OCTokenTypes.ELIF_DIRECTIVE || OCTokenTypes.IF_DIRECTIVES.contains(ctt)) {
                validBraceForPairing = OCBraceMatcher.cursorInSameSection(editor, fileText, false, braceStart, -1);
                break;
            }
            if (ctt == OCTokenTypes.DEFINE_DIRECTIVE) {
                if (OCBraceMatcher.cursorInSameSection(editor, fileText, true, iterator2.getStart(), -1)) {
                    validBraceForPairing = iteratorInTheSameLineWithBrace;
                    break;
                }
                if (OCBraceMatcher.cursorInSameSection(editor, fileText, true, iterator2.getStart(), braceStart)) {
                    validBraceForPairing = false;
                    break;
                }
            } else if (ctt == OCTokenTypes.ENDIF_DIRECTIVE && OCBraceMatcher.skipBackwardToStartIfDirective(iterator2)) break;
            iteratorInTheSameLineWithBrace &= !OCBraceMatcher.isMultilineWhitespace(iterator2, fileText, ctt);
            if (++count > 100) break;
            iterator2.retreat();
        }
        return validBraceForPairing;
    }

    private static boolean cursorInSameSection(@NotNull EditorEx editor, @NotNull CharSequence fileText, boolean newLineIsEndOfSection, int startBrace, int startAnchor) {
        IElementType ctt;
        boolean forward;
        HighlighterIterator iterator2 = editor.getHighlighter().createIterator(startBrace);
        if (startAnchor == -1) {
            startAnchor = editor.getCaretModel().getOffset();
        }
        IElementType tt = iterator2.getTokenType();
        boolean bl = forward = startAnchor > iterator2.getStart();
        do {
            if (forward) {
                iterator2.advance();
                if (iterator2.atEnd() || startAnchor <= iterator2.getStart()) {
                    return true;
                }
            } else {
                iterator2.retreat();
                if (iterator2.atEnd() || startAnchor >= iterator2.getStart()) {
                    return true;
                }
            }
            ctt = iterator2.getTokenType();
            if (newLineIsEndOfSection && OCBraceMatcher.isMultilineWhitespace(iterator2, fileText, ctt)) {
                return false;
            }
            if (ctt == OCTokenTypes.ELSE_DIRECTIVE || ctt == OCTokenTypes.ELIF_DIRECTIVE) {
                return false;
            }
            if (forward || ctt != OCTokenTypes.ENDIF_DIRECTIVE || !OCBraceMatcher.skipBackwardToStartIfDirective(iterator2)) continue;
            return false;
        } while (!forward || !OCTokenTypes.IF_DIRECTIVES.contains(ctt) || !OCBraceMatcher.skipForwardToEndIfDirective(iterator2));
        return false;
    }

    private static boolean isMultilineWhitespace(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull IElementType ctt) {
        return ctt == TokenType.WHITE_SPACE && StringUtil.contains((CharSequence)fileText, (int)iterator2.getStart(), (int)iterator2.getEnd(), (char)'\n');
    }

    @Nullable
    private static EditorEx getEditor(@NotNull HighlighterIterator iterator2) {
        if (iterator2 instanceof LexerEditorHighlighter.HighlighterIteratorImpl && ((LexerEditorHighlighter.HighlighterIteratorImpl)iterator2).getClient() instanceof EditorEx) {
            return (EditorEx)((LexerEditorHighlighter.HighlighterIteratorImpl)iterator2).getClient();
        }
        return null;
    }

    private static boolean skipBackwardToStartIfDirective(@NotNull HighlighterIterator iterator2) {
        iterator2.retreat();
        while (!iterator2.atEnd() && !OCTokenTypes.IF_DIRECTIVES.contains(iterator2.getTokenType())) {
            if (iterator2.getTokenType() == OCTokenTypes.ENDIF_DIRECTIVE && OCBraceMatcher.skipBackwardToStartIfDirective(iterator2)) {
                return true;
            }
            iterator2.retreat();
        }
        return iterator2.atEnd();
    }

    private static boolean skipForwardToEndIfDirective(@NotNull HighlighterIterator iterator2) {
        iterator2.advance();
        while (!iterator2.atEnd() && iterator2.getTokenType() != OCTokenTypes.ENDIF_DIRECTIVE) {
            if (OCTokenTypes.IF_DIRECTIVES.contains(iterator2.getTokenType()) && OCBraceMatcher.skipForwardToEndIfDirective(iterator2)) {
                return true;
            }
            iterator2.advance();
        }
        return iterator2.atEnd();
    }

    public OCBraceMatcher() {
        super((PairedBraceMatcher)new OCBraceMatcherInner(), (Language)OCLanguage.getInstance());
    }

    private static class OCBraceMatcherInner
    implements PairedBraceMatcher {
        private OCBraceMatcherInner() {
        }

        public BracePair @NotNull [] getPairs() {
            return PAIRS;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (contextType instanceof OCElementType) {
                return OCBraceMatcherInner.isPairedBracesAllowedBeforeTypeInJava(contextType);
            }
            return true;
        }

        private static boolean isPairedBracesAllowedBeforeTypeInJava(IElementType tokenType) {
            return OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tokenType) || tokenType == OCTokenTypes.SEMICOLON || tokenType == OCTokenTypes.COMMA || tokenType == OCTokenTypes.RPAR || tokenType == OCTokenTypes.RBRACKET || tokenType == OCTokenTypes.RBRACE || tokenType == OCTokenTypes.LBRACE;
        }

        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }
}

