/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCControlFlowGraph {
    private final PsiElement myCodeFragment;
    private final List<OCNode> myNodes = new ArrayList<OCNode>();
    private OCNode myStartNode;
    private final Set<OCNode> myExitNodes = new LinkedHashSet<OCNode>();
    private final Set<OCNode> myReturnNodes = new LinkedHashSet<OCNode>();
    private final OCControlFlowGraph myParentGraph;
    private int myForbidSplitNodesDepth;
    private int myNextNodeId;
    private final LinkedHashMap<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>> myInstructions = new LinkedHashMap();
    private final LinkedHashMap<PsiElement, OCInstruction> myReadInstructions = new LinkedHashMap();
    private final Set<OCInstruction> myAllInstructions = new LinkedHashSet<OCInstruction>();
    private final LinkedHashMap<OCSymbol, OCInstruction> myDeclarators = new LinkedHashMap();
    private final LinkedHashMap<OCSymbol, OCControlFlowGraph> myClosureVariables = new LinkedHashMap();

    public OCControlFlowGraph(@NotNull PsiElement codeFragment, @Nullable OCControlFlowGraph parentGraph) {
        this.myCodeFragment = codeFragment;
        this.myParentGraph = parentGraph;
    }

    @NotNull
    public List<OCNode> getNodes() {
        return this.myNodes;
    }

    public int getNumOfNodes() {
        return this.myNodes.size();
    }

    public int getNextNodeId() {
        return this.myNextNodeId++;
    }

    @NotNull
    public OCNode addNode() {
        return this.addNode(false);
    }

    @NotNull
    public OCNode addNode(boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            OCNode node2 = new OCNode(this, this.myNodes.size(), this.myNextNodeId++, isFake);
            this.myNodes.add(node2);
            return node2;
        }
        return this.getLastAddedNode();
    }

    public void forbidSplittingNodes() {
        ++this.myForbidSplitNodesDepth;
    }

    public void allowSplittingNodes() {
        --this.myForbidSplitNodesDepth;
    }

    public boolean isSplitNodesAllowed() {
        return this.myForbidSplitNodesDepth == 0;
    }

    public void removeNode(@NotNull OCNode node2, boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            assert (this.getLastAddedNode() == node2 && (node2.isEmpty() || node2.isFake()));
            this.myNodes.remove(this.getNumOfNodes() - 1);
        }
    }

    public void setStartNode(@NotNull OCNode startNode) {
        this.myStartNode = startNode;
    }

    @NotNull
    public OCNode getStartNode() {
        return this.myStartNode;
    }

    public void addReturnNode(@NotNull OCNode node2) {
        this.myExitNodes.add(node2);
        this.myReturnNodes.add(node2);
    }

    public void addExitNode(@NotNull OCNode node2) {
        this.myExitNodes.add(node2);
    }

    @NotNull
    public Set<OCNode> getExitNodes() {
        return this.myExitNodes;
    }

    @NotNull
    public Set<OCNode> getReturnNodes() {
        return this.myReturnNodes;
    }

    @Nullable
    public OCNode getPreviousNonEmptyNode(@NotNull OCNode node2) {
        for (int index = node2.getIndex() - 1; index >= 0; --index) {
            if (this.myNodes.get(index).getRange() == null) continue;
            return this.myNodes.get(index);
        }
        return null;
    }

    @NotNull
    public OCNode getLastAddedNode() {
        return this.myNodes.get(this.getNumOfNodes() - 1);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        return this.addInstruction(this.getLastAddedNode(), kind, null, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        return this.addInstruction(this.getLastAddedNode(), kind, lValue, rValue, symbol);
    }

    @Nullable
    private OCInstruction addInstruction(@NotNull OCNode node2, OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        OCInstruction instruction = new OCInstruction(kind, node2, lValue, rValue, symbol);
        if (kind == OCInstruction.InstructionKind.WRITE) {
            OCInstruction read = this.myReadInstructions.get(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue));
            if (read != null && read.getKind() == OCInstruction.InstructionKind.READ) {
                read.setAssociatedInstruction(instruction);
                instruction.setAssociatedInstruction(read);
            }
        } else if (kind == OCInstruction.InstructionKind.READ) {
            this.myReadInstructions.put(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue), instruction);
        }
        if (kind == OCInstruction.InstructionKind.DECLARATOR) {
            this.myDeclarators.put(symbol, instruction);
        } else if (!this.myDeclarators.containsKey(symbol)) {
            OCControlFlowGraph parent = this.myParentGraph;
            while (parent != null && !parent.myDeclarators.containsKey(symbol)) {
                parent = parent.myParentGraph;
            }
            if (parent != null) {
                this.myClosureVariables.put(symbol, parent);
            }
        }
        MultiMap multiMap = this.myInstructions.get(symbol);
        if (multiMap == null) {
            multiMap = MultiMap.createLinked();
            this.myInstructions.put(symbol, (MultiMap<OCInstruction.InstructionKind, OCInstruction>)multiMap);
        }
        multiMap.putValue((Object)kind, (Object)instruction);
        this.myAllInstructions.add(instruction);
        node2.addInstruction(instruction);
        return instruction;
    }

    public void addInstructions(@NotNull OCNode node2, @NotNull OCInstruction.InstructionKind kind, @NotNull Collection<OCInstruction> instructions) {
        for (OCInstruction instruction : instructions) {
            OCInstruction newInstruction = this.addInstruction(node2, kind, instruction.getLValue(), instruction.getRValue(), instruction.getSymbol());
            if (newInstruction == null) continue;
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            newInstruction.setAssociatedInstruction(associatedInstruction != null ? associatedInstruction : instruction);
        }
    }

    @Nullable
    public MultiMap<OCInstruction.InstructionKind, OCInstruction> getInstructions(@NotNull OCSymbol symbol) {
        return this.myInstructions.get(symbol);
    }

    public Set<OCInstruction> getAllInstructions() {
        return this.myAllInstructions;
    }

    public OCInstruction getDeclaratorInstruction(@NotNull OCSymbol symbol) {
        return this.myDeclarators.get(symbol);
    }

    public Set<OCSymbol> getLocalSymbols() {
        return this.myDeclarators.keySet();
    }

    public Set<OCSymbol> getClosureSymbols() {
        return this.myClosureVariables.keySet();
    }

    public OCControlFlowGraph getClosureVariableDeclaratorGraph(@NotNull OCSymbol symbol) {
        return this.myClosureVariables.get(symbol);
    }

    @NotNull
    public PsiElement getCodeFragment() {
        return this.myCodeFragment;
    }

    @Nullable
    public OCControlFlowGraph getParentGraph() {
        return this.myParentGraph;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append("<CFG>\n");
        String fileText = this.myCodeFragment.getContainingFile().getText();
        for (OCNode node2 : this.myNodes) {
            String nodeName = "node";
            if (node2 == this.myStartNode) {
                nodeName = "start-node";
            } else if (this.myExitNodes.contains(node2)) {
                nodeName = "exit-node";
            }
            result2.append("  <").append(nodeName).append(" id=\"").append(node2.getIndex()).append("\">\n");
            OCElementsRange range = node2.getRange();
            if (range != null) {
                TextRange textRange = range.getTextRange();
                result2.append(textRange.substring(fileText).trim()).append("\n");
            }
            if (node2.getJumpTargets() != null) {
                for (OCNode target : node2.getJumpTargets()) {
                    result2.append("    <target node-id=\"").append(target.getIndex()).append("\"/>\n");
                }
            }
            result2.append("  </").append(nodeName).append(">\n");
        }
        result2.append("</CFG>\n");
        return result2.toString();
    }

    public boolean hasInstructionsInParentGraph(@NotNull OCSymbol symbol, OCInstruction.InstructionKind ... kinds) {
        OCControlFlowGraph parentCfg = this.getClosureVariableDeclaratorGraph(symbol);
        if (parentCfg == null) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = parentCfg.getInstructions(symbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction.InstructionKind kind : kinds) {
            for (OCInstruction instruction : instructions.get((Object)kind)) {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getNode().getGraph() == this) continue;
                return true;
            }
        }
        return false;
    }
}

