/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ByteToCharOffsetMapBuilder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV1;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV2;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV3;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDataV4;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV1;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV2;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV3;
import com.jetbrains.cidr.lang.daemon.clang.tidy.YamlDiagnosticV4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;

public class ClangTidyYamlLoader {
    private static final Logger LOG = Logger.getInstance(ClangTidyYamlLoader.class);

    public List<ClangTidyDiagnostic> load(@NotNull String yamlContent, @NotNull String sourceFilePath, @NotNull OverlayMapping overlayMapping) {
        List<YamlDiagnosticV4> diagnostics2;
        if (StringUtil.isEmpty((String)(yamlContent = yamlContent.replaceAll("(\\V)\\n'", "$1\n\n'")))) {
            LOG.info("clang-tidy output is empty");
            return ContainerUtil.emptyList();
        }
        Ref yamlDataV4 = Ref.create();
        Ref yamlDataV3 = Ref.create();
        Ref yamlDataV2 = Ref.create();
        Ref yamlDataV1 = Ref.create();
        if (this.tryLoadYamlData(yamlContent, yamlDataV4, YamlDataV4.class, YamlDiagnosticV4.class)) {
            diagnostics2 = ((YamlDataV4)yamlDataV4.get()).Diagnostics != null ? new ArrayList<YamlDiagnosticV4>(((YamlDataV4)yamlDataV4.get()).Diagnostics) : ContainerUtil.emptyList();
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV3, YamlDataV3.class, YamlDiagnosticV3.class)) {
            diagnostics2 = ((YamlDataV3)yamlDataV3.get()).Diagnostics != null ? new ArrayList<YamlDiagnosticV3>(((YamlDataV3)yamlDataV3.get()).Diagnostics) : ContainerUtil.emptyList();
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV2, YamlDataV2.class, YamlDiagnosticV2.class)) {
            diagnostics2 = ((YamlDataV2)yamlDataV2.get()).Diagnostics != null ? new ArrayList<YamlDiagnosticV2>(((YamlDataV2)yamlDataV2.get()).Diagnostics) : ContainerUtil.emptyList();
        } else if (this.tryLoadYamlData(yamlContent, yamlDataV1, YamlDataV1.class, YamlDiagnosticV1.class)) {
            diagnostics2 = ((YamlDataV1)yamlDataV1.get()).Diagnostics != null ? new ArrayList<YamlDiagnosticV1>(((YamlDataV1)yamlDataV1.get()).Diagnostics) : ContainerUtil.emptyList();
        } else {
            LOG.error("clang-tidy output format is not recognized");
            return ContainerUtil.emptyList();
        }
        diagnostics2.removeIf(d -> !d.isValid() || d.isSuppressed());
        diagnostics2.forEach(d -> d.mapOverlaysToSourceFiles(overlayMapping));
        diagnostics2.removeIf(d -> !d.appliedToSourceFile(sourceFilePath));
        Map<String, Map<Integer, Integer>> byteToCharOffsetMap = ClangTidyYamlLoader.createByteToCharOffsetMap((List<YamlDiagnostic>)diagnostics2, overlayMapping);
        return ContainerUtil.map((Collection)diagnostics2, d -> d.toClangTidyDiagnostic(byteToCharOffsetMap));
    }

    private <T> boolean tryLoadYamlData(@NotNull String yamlContent, Ref<T> output, Class<T> outputClass, Class<?> diagnosticClass) {
        try {
            CustomClassLoaderConstructor constructor = new CustomClassLoaderConstructor(outputClass, this.getClass().getClassLoader());
            TypeDescription diagsDesc = new TypeDescription(outputClass);
            diagsDesc.addPropertyParameters("Diagnostics", new Class[]{diagnosticClass});
            constructor.addTypeDescription(diagsDesc);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            output.set(yaml.loadAs(yamlContent, outputClass));
            return output.get() != null;
        }
        catch (Exception e) {
            LOG.warn("Can't deserialize clang-tidy output of type " + outputClass.getSimpleName() + ": " + e.getMessage());
            return false;
        }
    }

    private static Map<String, Map<Integer, Integer>> createByteToCharOffsetMap(@NotNull List<YamlDiagnostic> diagnostics2, @NotNull OverlayMapping overlayMapping) {
        Set<String> unsavedFilePaths = overlayMapping.getSourceFiles().stream().map(file2 -> file2.getPath()).collect(Collectors.toSet());
        ByteToCharOffsetMapBuilder builder2 = new ByteToCharOffsetMapBuilder();
        HashMap<String, SortedSet<Integer>> fileToByteOffset = new HashMap<String, SortedSet<Integer>>();
        for (YamlDiagnostic diagnostic : diagnostics2) {
            diagnostic.addOffsets(fileToByteOffset);
        }
        return builder2.createFor(fileToByteOffset, unsavedFilePaths);
    }
}

