/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClangTidyDocumentListener
implements DocumentListener {
    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Document document2 = event.getDocument();
        int startOffset = DocumentUtil.getLineStartOffset((int)event.getOffset(), (Document)document2);
        int endOffset = DocumentUtil.getLineEndOffset((int)(startOffset + event.getOldLength()), (Document)document2);
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        SmartList infosToDispose = new SmartList();
        for (Project project2 : openProjects) {
            PsiDocumentManager documentManager;
            if (!project2.isInitialized() || project2.isDisposed() || (documentManager = PsiDocumentManager.getInstance((Project)project2)).getCachedPsiFile(document2) == null) continue;
            DaemonCodeAnalyzerEx.processHighlights((Document)document2, (Project)project2, null, (int)startOffset, (int)endOffset, arg_0 -> ClangTidyDocumentListener.lambda$beforeDocumentChange$0((List)infosToDispose, arg_0));
        }
        for (HighlightInfo info : infosToDispose) {
            info.getHighlighter().dispose();
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
    }

    private static /* synthetic */ boolean lambda$beforeDocumentChange$0(List infosToDispose, HighlightInfo info) {
        if (info.getProblemGroup() instanceof ClangTidyProblemGroup) {
            infosToDispose.add(info);
        }
        return true;
    }
}

