/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.ClangdPanelBaseKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.toolwindow.SetClangdProjectData;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0002J$\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u001a\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/SetCompileCommandAction;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/toolwindow/SetClangdProjectData;", "", "", "()V", "commandLine2Text", "commandLine", "getCommandsMap", "", "project", "Lcom/intellij/openapi/project/Project;", "getDialogTitle", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "getValue", "setValue", "", "text", "text2CommandLine", "intellij.c"})
final class SetCompileCommandAction
extends SetClangdProjectData<List<? extends String>> {
    @Override
    @NotNull
    protected String getDialogTitle(@NotNull Project project2, @NotNull DataContext dc) {
        return super.getDialogTitle(project2, dc) + ClangdPanelBaseKt.access$currentFilePath(dc);
    }

    @Override
    @NotNull
    protected String getValue(@NotNull Project project2, @NotNull DataContext dc) {
        String filePath = ClangdPanelBaseKt.access$currentFilePath(dc);
        if (filePath == null) {
            return "";
        }
        Map<String, List<String>> commandsMap = this.getCommandsMap(project2);
        List<String> commandLine = commandsMap.get(filePath);
        return this.commandLine2Text(commandLine);
    }

    @Override
    protected void setValue(@NotNull Project project2, @NotNull DataContext dc, @NotNull String text) {
        String filePath = ClangdPanelBaseKt.access$currentFilePath(dc);
        if (filePath == null) {
            return;
        }
        Map<String, List<String>> commandsMap = this.getCommandsMap(project2);
        commandsMap.put(filePath, this.text2CommandLine(text));
    }

    private final Map<String, List<String>> getCommandsMap(Project project2) {
        Map commandsMap = (Map)project2.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
        if (commandsMap != null) {
            return commandsMap;
        }
        commandsMap = new HashMap();
        project2.putUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS, (Object)commandsMap);
        return commandsMap;
    }

    private final List<String> text2CommandLine(String text) {
        if (text == null) {
            return null;
        }
        return CidrSwitchBuilder.parseArgs(text, CidrCompilerSwitches.Format.BASH_SHELL);
    }

    private final String commandLine2Text(List<String> commandLine) {
        if (commandLine == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean rest = false;
        for (String option : commandLine) {
            if (rest) {
                sb.append(" ");
            }
            sb.append(option);
            rest = true;
        }
        return sb.toString();
    }

    public SetCompileCommandAction() {
        super("Set compilation command for the current file", AllIcons.Actions.Properties, "Enter compilation command", "Compilation command for ");
    }
}

