/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.startup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.jetbrains.cidr.lang.daemon.OCLegacyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.EditorOpenRequestId;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class ClangLanguageServiceStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ClangLanguageServiceStartupActivity.runStartupActivity(project2);
        ClangLanguageServiceStartupActivity.configureDefaultAnnotators(project2);
    }

    public static void runStartupActivity(@NotNull Project project2) {
        if (project2.isDefault() || project2.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project2.isDisposed()) {
                return;
            }
            ClangLanguageServiceProvider provider2 = ClangLanguageServiceProvider.getProvider(project2);
            if (provider2 == null) {
                return;
            }
            final ClangLanguageServiceProvider[] providers = new ClangLanguageServiceProvider[]{provider2};
            if (ClangUtils.isClangdOn(project2)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(providers, project2);
            }
            project2.getMessageBus().connect().subscribe(ClangdSettingsListener.TOPIC, (Object)new MyClangdSettingsListener(project2, providers));
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getDocument());
                    for (ClangLanguageServiceProvider provider2 : providers) {
                        ClangLanguageService service;
                        if (file2 == null || (service = provider2.getIfStarted()) == null) continue;
                        service.notifyDocumentChanged(file2, event);
                    }
                }
            }, (Disposable)project2);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorCreated(@NotNull EditorFactoryEvent event) {
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file2 != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getIfStarted();
                            if (service == null) continue;
                            service.notifyDocumentOpened(file2, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    VirtualFile file2 = FileDocumentManager.getInstance().getFile(event.getEditor().getDocument());
                    if (file2 != null) {
                        for (ClangLanguageServiceProvider provider2 : providers) {
                            ClangLanguageService service = provider2.getIfStarted();
                            if (service == null) continue;
                            service.notifyDocumentClosed(file2, new EditorOpenRequestId(event.getEditor()));
                        }
                    }
                }
            }, (Disposable)project2);
            project2.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                public void after(@NotNull List<? extends VFileEvent> events) {
                    for (VFileEvent vFileEvent : events) {
                        VFileMoveEvent event;
                        if (vFileEvent instanceof VFileMoveEvent) {
                            event = (VFileMoveEvent)vFileEvent;
                            VirtualFile file2 = event.getFile();
                            String oldUrl = event.getOldParent().getUrl() + "/" + file2.getName();
                            String newUrl = file2.getUrl();
                            for (ClangLanguageServiceProvider provider2 : providers) {
                                ClangLanguageService service = provider2.getIfStarted();
                                if (service == null) continue;
                                service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) {
                            event = (VFilePropertyChangeEvent)vFileEvent;
                            if (Objects.equals(event.getNewValue(), event.getOldValue())) continue;
                            String newName = (String)event.getNewValue();
                            String newUrl = event.getFile().getUrl();
                            assert (newUrl.endsWith(newName));
                            String oldName = (String)event.getOldValue();
                            String oldUrl = newUrl.substring(0, newUrl.length() - newName.length()) + oldName;
                            for (ClangLanguageServiceProvider provider3 : providers) {
                                ClangLanguageService service = provider3.getIfStarted();
                                if (service == null) continue;
                                service.notifyDocumentMoved(event.getFile(), oldUrl, newUrl);
                            }
                            continue;
                        }
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        event = (VFileContentChangeEvent)vFileEvent;
                        if (!vFileEvent.isFromSave()) continue;
                        VirtualFile file2 = event.getFile();
                        for (ClangLanguageServiceProvider provider4 : providers) {
                            ClangLanguageService service = provider4.getIfStarted();
                            if (service == null) continue;
                            service.notifyDocumentSaved(file2);
                        }
                    }
                }
            });
        });
    }

    private static void initLanguageServices(ClangLanguageServiceProvider @NotNull [] providers, @NotNull Project project2) {
        for (ClangLanguageServiceProvider provider2 : providers) {
            ClangLanguageService service = provider2.getOrStart();
            ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
                if (project2.isDisposed()) {
                    return;
                }
                if (!service.isActive()) {
                    return;
                }
                for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                    VirtualFile vFile;
                    Project editorProject = editor.getProject();
                    if (editorProject != project2 || (vFile = FileDocumentManager.getInstance().getFile(editor.getDocument())) == null) continue;
                    service.notifyDocumentOpened(vFile, new EditorOpenRequestId(editor));
                }
            }));
        }
    }

    private static void stopLanguageServices(ClangLanguageServiceProvider @NotNull [] providers) {
        for (ClangLanguageServiceProvider provider2 : providers) {
            provider2.stop();
        }
    }

    private static void configureDefaultAnnotators(@NotNull Project project2) {
        boolean legacy = !ClangUtils.isClangdOn(project2) || !ClangUtils.isClangdShowErrors(project2);
        OCLegacyAnnotator.enable(project2, legacy, true);
    }

    private static class MyClangdSettingsListener
    implements ClangdSettingsListener {
        @NotNull
        private final Project myProject;
        private final ClangLanguageServiceProvider @NotNull [] myProviders;

        MyClangdSettingsListener(@NotNull Project project2, ClangLanguageServiceProvider @NotNull [] providers) {
            this.myProject = project2;
            this.myProviders = providers;
        }

        @Override
        public void onClangdOnChanged(boolean value) {
            this.configureLanguageServices();
            ClangLanguageServiceStartupActivity.configureDefaultAnnotators(this.myProject);
        }

        @Override
        public void onClangdShowErrorsChanged(boolean value) {
            ClangLanguageServiceStartupActivity.configureDefaultAnnotators(this.myProject);
        }

        private void configureLanguageServices() {
            if (ClangUtils.isClangdOn(this.myProject)) {
                ClangLanguageServiceStartupActivity.initLanguageServices(this.myProviders, this.myProject);
            } else {
                ClangLanguageServiceStartupActivity.stopLanguageServices(this.myProviders);
            }
        }
    }
}

