/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

class PendingRequestsStorage {
    static final int FILES_STORAGE_SIZE = 64;
    @NotNull
    private final PendingParseListener myListener;
    @NotNull
    private final ArrayDeque<ClangParseResponseImpl> myPending;
    private final int myOverflowSize;
    private volatile ClangParseResponseImpl myLast;

    PendingRequestsStorage(@NotNull PendingParseListener listener) {
        this(listener, 64);
    }

    PendingRequestsStorage(@NotNull PendingParseListener listener, int size) {
        this.myListener = listener;
        this.myPending = new ArrayDeque(size);
        this.myOverflowSize = size;
        assert (this.myOverflowSize > 0);
    }

    public ClangParseResponseImpl getLast() {
        return this.myLast;
    }

    public synchronized void clearLast() {
        this.myLast = null;
    }

    public synchronized void onParse(@NotNull ClangParseResponseImpl t) {
        this.myLast = t;
        if (this.myOverflowSize <= this.myPending.size()) {
            ClangParseResponseImpl oldest = this.myPending.peekFirst();
            assert (oldest != null);
            this.myListener.onOverflow(oldest);
        }
        this.myPending.addLast(t);
        CompletableFuture.allOf(ClangParseResponse.getAllAnswers(t)).whenComplete((data, ex) -> this.removeWhenDone(t));
    }

    private synchronized void removeWhenDone(@NotNull ClangParseResponse t) {
        if (this.myPending.peekLast() == t) {
            this.myPending.removeLast();
        } else {
            this.myPending.removeFirstOccurrence(t);
        }
    }

    public synchronized int sizeOfPending() {
        return this.myPending.size();
    }

    public synchronized void forEachPending(@NotNull Predicate<ClangParseResponse> consumer) {
        for (ClangParseResponse clangParseResponse : this.myPending) {
            if (consumer.test(clangParseResponse)) continue;
            return;
        }
    }
}

